// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A widget on a CloudTrail Lake dashboard.
 */
public class Widget private constructor(builder: Builder) {
    /**
     * The query alias used to identify the query for the widget.
     */
    public val queryAlias: kotlin.String? = builder.queryAlias
    /**
     * The query parameters for the widget.
     */
    public val queryParameters: List<String>? = builder.queryParameters
    /**
     * The SQL query statement for the widget.
     */
    public val queryStatement: kotlin.String? = builder.queryStatement
    /**
     * The view properties for the widget. For more information about view properties, see [ View properties for widgets ](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-widget-properties.html) in the *CloudTrail User Guide*..
     */
    public val viewProperties: Map<String, String>? = builder.viewProperties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.Widget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Widget(")
        append("queryAlias=$queryAlias,")
        append("queryParameters=$queryParameters,")
        append("queryStatement=$queryStatement,")
        append("viewProperties=$viewProperties")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = queryAlias?.hashCode() ?: 0
        result = 31 * result + (queryParameters?.hashCode() ?: 0)
        result = 31 * result + (queryStatement?.hashCode() ?: 0)
        result = 31 * result + (viewProperties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Widget

        if (queryAlias != other.queryAlias) return false
        if (queryParameters != other.queryParameters) return false
        if (queryStatement != other.queryStatement) return false
        if (viewProperties != other.viewProperties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.Widget = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The query alias used to identify the query for the widget.
         */
        public var queryAlias: kotlin.String? = null
        /**
         * The query parameters for the widget.
         */
        public var queryParameters: List<String>? = null
        /**
         * The SQL query statement for the widget.
         */
        public var queryStatement: kotlin.String? = null
        /**
         * The view properties for the widget. For more information about view properties, see [ View properties for widgets ](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-widget-properties.html) in the *CloudTrail User Guide*..
         */
        public var viewProperties: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.Widget) : this() {
            this.queryAlias = x.queryAlias
            this.queryParameters = x.queryParameters
            this.queryStatement = x.queryStatement
            this.viewProperties = x.viewProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.Widget = Widget(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
