// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Returns the objects or data listed below if successful. Otherwise, returns an error.
 */
public class UpdateTrailResponse private constructor(builder: Builder) {
    /**
     * Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs are delivered.
     */
    public val cloudWatchLogsLogGroupArn: kotlin.String? = builder.cloudWatchLogsLogGroupArn
    /**
     * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
     */
    public val cloudWatchLogsRoleArn: kotlin.String? = builder.cloudWatchLogsRoleArn
    /**
     * Specifies whether the trail is publishing events from global services such as IAM to the log files.
     */
    public val includeGlobalServiceEvents: kotlin.Boolean? = builder.includeGlobalServiceEvents
    /**
     * Specifies whether the trail exists in one Region or in all Regions.
     */
    public val isMultiRegionTrail: kotlin.Boolean? = builder.isMultiRegionTrail
    /**
     * Specifies whether the trail is an organization trail.
     */
    public val isOrganizationTrail: kotlin.Boolean? = builder.isOrganizationTrail
    /**
     * Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.
     *
     * `arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012`
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies whether log file integrity validation is enabled.
     */
    public val logFileValidationEnabled: kotlin.Boolean? = builder.logFileValidationEnabled
    /**
     * Specifies the name of the trail.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies the name of the Amazon S3 bucket designated for publishing log files.
     */
    public val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see [Finding Your IAM Log Files](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/get-and-view-cloudtrail-log-files.html#cloudtrail-find-log-files).
     */
    public val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix
    /**
     * Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The following is the format of a topic ARN.
     *
     * `arn:aws:sns:us-east-2:123456789012:MyTopic`
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * This field is no longer in use. Use `SnsTopicARN`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val snsTopicName: kotlin.String? = builder.snsTopicName
    /**
     * Specifies the ARN of the trail that was updated. The following is the format of a trail ARN.
     *
     * `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
     */
    public val trailArn: kotlin.String? = builder.trailArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.UpdateTrailResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateTrailResponse(")
        append("cloudWatchLogsLogGroupArn=$cloudWatchLogsLogGroupArn,")
        append("cloudWatchLogsRoleArn=$cloudWatchLogsRoleArn,")
        append("includeGlobalServiceEvents=$includeGlobalServiceEvents,")
        append("isMultiRegionTrail=$isMultiRegionTrail,")
        append("isOrganizationTrail=$isOrganizationTrail,")
        append("kmsKeyId=$kmsKeyId,")
        append("logFileValidationEnabled=$logFileValidationEnabled,")
        append("name=$name,")
        append("s3BucketName=$s3BucketName,")
        append("s3KeyPrefix=$s3KeyPrefix,")
        append("snsTopicArn=$snsTopicArn,")
        append("snsTopicName=$snsTopicName,")
        append("trailArn=$trailArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogsLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (cloudWatchLogsRoleArn?.hashCode() ?: 0)
        result = 31 * result + (includeGlobalServiceEvents?.hashCode() ?: 0)
        result = 31 * result + (isMultiRegionTrail?.hashCode() ?: 0)
        result = 31 * result + (isOrganizationTrail?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (logFileValidationEnabled?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (snsTopicName?.hashCode() ?: 0)
        result = 31 * result + (trailArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateTrailResponse

        if (cloudWatchLogsLogGroupArn != other.cloudWatchLogsLogGroupArn) return false
        if (cloudWatchLogsRoleArn != other.cloudWatchLogsRoleArn) return false
        if (includeGlobalServiceEvents != other.includeGlobalServiceEvents) return false
        if (isMultiRegionTrail != other.isMultiRegionTrail) return false
        if (isOrganizationTrail != other.isOrganizationTrail) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (logFileValidationEnabled != other.logFileValidationEnabled) return false
        if (name != other.name) return false
        if (s3BucketName != other.s3BucketName) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (snsTopicName != other.snsTopicName) return false
        if (trailArn != other.trailArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.UpdateTrailResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs are delivered.
         */
        public var cloudWatchLogsLogGroupArn: kotlin.String? = null
        /**
         * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
         */
        public var cloudWatchLogsRoleArn: kotlin.String? = null
        /**
         * Specifies whether the trail is publishing events from global services such as IAM to the log files.
         */
        public var includeGlobalServiceEvents: kotlin.Boolean? = null
        /**
         * Specifies whether the trail exists in one Region or in all Regions.
         */
        public var isMultiRegionTrail: kotlin.Boolean? = null
        /**
         * Specifies whether the trail is an organization trail.
         */
        public var isOrganizationTrail: kotlin.Boolean? = null
        /**
         * Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.
         *
         * `arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012`
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies whether log file integrity validation is enabled.
         */
        public var logFileValidationEnabled: kotlin.Boolean? = null
        /**
         * Specifies the name of the trail.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies the name of the Amazon S3 bucket designated for publishing log files.
         */
        public var s3BucketName: kotlin.String? = null
        /**
         * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see [Finding Your IAM Log Files](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/get-and-view-cloudtrail-log-files.html#cloudtrail-find-log-files).
         */
        public var s3KeyPrefix: kotlin.String? = null
        /**
         * Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The following is the format of a topic ARN.
         *
         * `arn:aws:sns:us-east-2:123456789012:MyTopic`
         */
        public var snsTopicArn: kotlin.String? = null
        /**
         * This field is no longer in use. Use `SnsTopicARN`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var snsTopicName: kotlin.String? = null
        /**
         * Specifies the ARN of the trail that was updated. The following is the format of a trail ARN.
         *
         * `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
         */
        public var trailArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.UpdateTrailResponse) : this() {
            this.cloudWatchLogsLogGroupArn = x.cloudWatchLogsLogGroupArn
            this.cloudWatchLogsRoleArn = x.cloudWatchLogsRoleArn
            this.includeGlobalServiceEvents = x.includeGlobalServiceEvents
            this.isMultiRegionTrail = x.isMultiRegionTrail
            this.isOrganizationTrail = x.isOrganizationTrail
            this.kmsKeyId = x.kmsKeyId
            this.logFileValidationEnabled = x.logFileValidationEnabled
            this.name = x.name
            this.s3BucketName = x.s3BucketName
            this.s3KeyPrefix = x.s3KeyPrefix
            this.snsTopicArn = x.snsTopicArn
            this.snsTopicName = x.snsTopicName
            this.trailArn = x.trailArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.UpdateTrailResponse = UpdateTrailResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
