// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateEventDataStoreRequest private constructor(builder: Builder) {
    /**
     * The advanced event selectors used to select events for the event data store. You can configure up to five advanced event selectors for each event data store.
     */
    public val advancedEventSelectors: List<AdvancedEventSelector>? = builder.advancedEventSelectors
    /**
     * You can't change the billing mode from `EXTENDABLE_RETENTION_PRICING` to `FIXED_RETENTION_PRICING`. If `BillingMode` is set to `EXTENDABLE_RETENTION_PRICING` and you want to use `FIXED_RETENTION_PRICING` instead, you'll need to stop ingestion on the event data store and create a new event data store that uses `FIXED_RETENTION_PRICING`.
     *
     * The billing mode for the event data store determines the cost for ingesting events and the default and maximum retention period for the event data store.
     *
     * The following are the possible values:
     * + `EXTENDABLE_RETENTION_PRICING` - This billing mode is generally recommended if you want a flexible retention period of up to 3653 days (about 10 years). The default retention period for this billing mode is 366 days.
     * + `FIXED_RETENTION_PRICING` - This billing mode is recommended if you expect to ingest more than 25 TB of event data per month and need a retention period of up to 2557 days (about 7 years). The default retention period for this billing mode is 2557 days.
     *
     * For more information about CloudTrail pricing, see [CloudTrail Pricing](http://aws.amazon.com/cloudtrail/pricing/) and [Managing CloudTrail Lake costs](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-manage-costs.html).
     */
    public val billingMode: aws.sdk.kotlin.services.cloudtrail.model.BillingMode? = builder.billingMode
    /**
     * The ARN (or the ID suffix of the ARN) of the event data store that you want to update.
     */
    public val eventDataStore: kotlin.String? = builder.eventDataStore
    /**
     * Specifies the KMS key ID to use to encrypt the events delivered by CloudTrail. The value can be an alias name prefixed by `alias/`, a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
     *
     * Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail from logging events to the event data store, and prevents users from querying the data in the event data store that was encrypted with the key. After you associate an event data store with a KMS key, the KMS key cannot be removed or changed. Before you disable or delete a KMS key that you are using with an event data store, delete or back up your event data store.
     *
     * CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see [Using multi-Region keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *Key Management Service Developer Guide*.
     *
     * Examples:
     * + `alias/MyAliasName`
     * + `arn:aws:kms:us-east-2:123456789012:alias/MyAliasName`
     * + `arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012`
     * + `12345678-1234-1234-1234-123456789012`
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies whether an event data store collects events from all Regions, or only from the Region in which it was created.
     */
    public val multiRegionEnabled: kotlin.Boolean? = builder.multiRegionEnabled
    /**
     * The event data store name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies whether an event data store collects events logged for an organization in Organizations.
     *
     * Only the management account for the organization can convert an organization event data store to a non-organization event data store, or convert a non-organization event data store to an organization event data store.
     */
    public val organizationEnabled: kotlin.Boolean? = builder.organizationEnabled
    /**
     * The retention period of the event data store, in days. If `BillingMode` is set to `EXTENDABLE_RETENTION_PRICING`, you can set a retention period of up to 3653 days, the equivalent of 10 years. If `BillingMode` is set to `FIXED_RETENTION_PRICING`, you can set a retention period of up to 2557 days, the equivalent of seven years.
     *
     * CloudTrail Lake determines whether to retain an event by checking if the `eventTime` of the event is within the specified retention period. For example, if you set a retention period of 90 days, CloudTrail will remove events when the `eventTime` is older than 90 days.
     *
     * If you decrease the retention period of an event data store, CloudTrail will remove any events with an `eventTime` older than the new retention period. For example, if the previous retention period was 365 days and you decrease it to 100 days, CloudTrail will remove events with an `eventTime` older than 100 days.
     */
    public val retentionPeriod: kotlin.Int? = builder.retentionPeriod
    /**
     * Indicates that termination protection is enabled and the event data store cannot be automatically deleted.
     */
    public val terminationProtectionEnabled: kotlin.Boolean? = builder.terminationProtectionEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.UpdateEventDataStoreRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateEventDataStoreRequest(")
        append("advancedEventSelectors=$advancedEventSelectors,")
        append("billingMode=$billingMode,")
        append("eventDataStore=$eventDataStore,")
        append("kmsKeyId=$kmsKeyId,")
        append("multiRegionEnabled=$multiRegionEnabled,")
        append("name=$name,")
        append("organizationEnabled=$organizationEnabled,")
        append("retentionPeriod=$retentionPeriod,")
        append("terminationProtectionEnabled=$terminationProtectionEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = advancedEventSelectors?.hashCode() ?: 0
        result = 31 * result + (billingMode?.hashCode() ?: 0)
        result = 31 * result + (eventDataStore?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (multiRegionEnabled?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (organizationEnabled?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod ?: 0)
        result = 31 * result + (terminationProtectionEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateEventDataStoreRequest

        if (advancedEventSelectors != other.advancedEventSelectors) return false
        if (billingMode != other.billingMode) return false
        if (eventDataStore != other.eventDataStore) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (multiRegionEnabled != other.multiRegionEnabled) return false
        if (name != other.name) return false
        if (organizationEnabled != other.organizationEnabled) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (terminationProtectionEnabled != other.terminationProtectionEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.UpdateEventDataStoreRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The advanced event selectors used to select events for the event data store. You can configure up to five advanced event selectors for each event data store.
         */
        public var advancedEventSelectors: List<AdvancedEventSelector>? = null
        /**
         * You can't change the billing mode from `EXTENDABLE_RETENTION_PRICING` to `FIXED_RETENTION_PRICING`. If `BillingMode` is set to `EXTENDABLE_RETENTION_PRICING` and you want to use `FIXED_RETENTION_PRICING` instead, you'll need to stop ingestion on the event data store and create a new event data store that uses `FIXED_RETENTION_PRICING`.
         *
         * The billing mode for the event data store determines the cost for ingesting events and the default and maximum retention period for the event data store.
         *
         * The following are the possible values:
         * + `EXTENDABLE_RETENTION_PRICING` - This billing mode is generally recommended if you want a flexible retention period of up to 3653 days (about 10 years). The default retention period for this billing mode is 366 days.
         * + `FIXED_RETENTION_PRICING` - This billing mode is recommended if you expect to ingest more than 25 TB of event data per month and need a retention period of up to 2557 days (about 7 years). The default retention period for this billing mode is 2557 days.
         *
         * For more information about CloudTrail pricing, see [CloudTrail Pricing](http://aws.amazon.com/cloudtrail/pricing/) and [Managing CloudTrail Lake costs](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-manage-costs.html).
         */
        public var billingMode: aws.sdk.kotlin.services.cloudtrail.model.BillingMode? = null
        /**
         * The ARN (or the ID suffix of the ARN) of the event data store that you want to update.
         */
        public var eventDataStore: kotlin.String? = null
        /**
         * Specifies the KMS key ID to use to encrypt the events delivered by CloudTrail. The value can be an alias name prefixed by `alias/`, a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
         *
         * Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail from logging events to the event data store, and prevents users from querying the data in the event data store that was encrypted with the key. After you associate an event data store with a KMS key, the KMS key cannot be removed or changed. Before you disable or delete a KMS key that you are using with an event data store, delete or back up your event data store.
         *
         * CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see [Using multi-Region keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *Key Management Service Developer Guide*.
         *
         * Examples:
         * + `alias/MyAliasName`
         * + `arn:aws:kms:us-east-2:123456789012:alias/MyAliasName`
         * + `arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012`
         * + `12345678-1234-1234-1234-123456789012`
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies whether an event data store collects events from all Regions, or only from the Region in which it was created.
         */
        public var multiRegionEnabled: kotlin.Boolean? = null
        /**
         * The event data store name.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies whether an event data store collects events logged for an organization in Organizations.
         *
         * Only the management account for the organization can convert an organization event data store to a non-organization event data store, or convert a non-organization event data store to an organization event data store.
         */
        public var organizationEnabled: kotlin.Boolean? = null
        /**
         * The retention period of the event data store, in days. If `BillingMode` is set to `EXTENDABLE_RETENTION_PRICING`, you can set a retention period of up to 3653 days, the equivalent of 10 years. If `BillingMode` is set to `FIXED_RETENTION_PRICING`, you can set a retention period of up to 2557 days, the equivalent of seven years.
         *
         * CloudTrail Lake determines whether to retain an event by checking if the `eventTime` of the event is within the specified retention period. For example, if you set a retention period of 90 days, CloudTrail will remove events when the `eventTime` is older than 90 days.
         *
         * If you decrease the retention period of an event data store, CloudTrail will remove any events with an `eventTime` older than the new retention period. For example, if the previous retention period was 365 days and you decrease it to 100 days, CloudTrail will remove events with an `eventTime` older than 100 days.
         */
        public var retentionPeriod: kotlin.Int? = null
        /**
         * Indicates that termination protection is enabled and the event data store cannot be automatically deleted.
         */
        public var terminationProtectionEnabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.UpdateEventDataStoreRequest) : this() {
            this.advancedEventSelectors = x.advancedEventSelectors
            this.billingMode = x.billingMode
            this.eventDataStore = x.eventDataStore
            this.kmsKeyId = x.kmsKeyId
            this.multiRegionEnabled = x.multiRegionEnabled
            this.name = x.name
            this.organizationEnabled = x.organizationEnabled
            this.retentionPeriod = x.retentionPeriod
            this.terminationProtectionEnabled = x.terminationProtectionEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.UpdateEventDataStoreRequest = UpdateEventDataStoreRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
