// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about a widget on a CloudTrail Lake dashboard.
 */
public class RequestWidget private constructor(builder: Builder) {
    /**
     * The optional query parameters. The following query parameters are valid: `$StartTime$`, `$EndTime$`, and `$Period$`.
     */
    public val queryParameters: List<String>? = builder.queryParameters
    /**
     * The query statement for the widget. For custom dashboard widgets, you can query across multiple event data stores as long as all event data stores exist in your account.
     *
     * When a query uses `?` with `eventTime`, `?` must be surrounded by single quotes as follows: `'?'`.
     */
    public val queryStatement: kotlin.String = requireNotNull(builder.queryStatement) { "A non-null value must be provided for queryStatement" }
    /**
     * The view properties for the widget. For more information about view properties, see [ View properties for widgets ](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-widget-properties.html) in the *CloudTrail User Guide*.
     */
    public val viewProperties: Map<String, String> = requireNotNull(builder.viewProperties) { "A non-null value must be provided for viewProperties" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.RequestWidget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RequestWidget(")
        append("queryParameters=$queryParameters,")
        append("queryStatement=$queryStatement,")
        append("viewProperties=$viewProperties")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = queryParameters?.hashCode() ?: 0
        result = 31 * result + (queryStatement.hashCode())
        result = 31 * result + (viewProperties.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RequestWidget

        if (queryParameters != other.queryParameters) return false
        if (queryStatement != other.queryStatement) return false
        if (viewProperties != other.viewProperties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.RequestWidget = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The optional query parameters. The following query parameters are valid: `$StartTime$`, `$EndTime$`, and `$Period$`.
         */
        public var queryParameters: List<String>? = null
        /**
         * The query statement for the widget. For custom dashboard widgets, you can query across multiple event data stores as long as all event data stores exist in your account.
         *
         * When a query uses `?` with `eventTime`, `?` must be surrounded by single quotes as follows: `'?'`.
         */
        public var queryStatement: kotlin.String? = null
        /**
         * The view properties for the widget. For more information about view properties, see [ View properties for widgets ](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-widget-properties.html) in the *CloudTrail User Guide*.
         */
        public var viewProperties: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.RequestWidget) : this() {
            this.queryParameters = x.queryParameters
            this.queryStatement = x.queryStatement
            this.viewProperties = x.viewProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.RequestWidget = RequestWidget(this)

        internal fun correctErrors(): Builder {
            if (queryStatement == null) queryStatement = ""
            if (viewProperties == null) viewProperties = emptyMap()
            return this
        }
    }
}
