// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the tags to remove from a trail, event data store, dashboard, or channel.
 */
public class RemoveTagsRequest private constructor(builder: Builder) {
    /**
     * Specifies the ARN of the trail, event data store, dashboard, or channel from which tags should be removed.
     *
     *  Example trail ARN format: `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
     *
     * Example event data store ARN format: `arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE`
     *
     * Example dashboard ARN format: `arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash`
     *
     * Example channel ARN format: `arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890`
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * Specifies a list of tags to be removed.
     */
    public val tagsList: List<Tag>? = builder.tagsList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.RemoveTagsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RemoveTagsRequest(")
        append("resourceId=$resourceId,")
        append("tagsList=$tagsList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceId?.hashCode() ?: 0
        result = 31 * result + (tagsList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RemoveTagsRequest

        if (resourceId != other.resourceId) return false
        if (tagsList != other.tagsList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.RemoveTagsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the ARN of the trail, event data store, dashboard, or channel from which tags should be removed.
         *
         *  Example trail ARN format: `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
         *
         * Example event data store ARN format: `arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE`
         *
         * Example dashboard ARN format: `arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash`
         *
         * Example channel ARN format: `arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890`
         */
        public var resourceId: kotlin.String? = null
        /**
         * Specifies a list of tags to be removed.
         */
        public var tagsList: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.RemoveTagsRequest) : this() {
            this.resourceId = x.resourceId
            this.tagsList = x.tagsList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.RemoveTagsRequest = RemoveTagsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
