// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the frequency for a dashboard refresh schedule.
 *
 *  For a custom dashboard, you can schedule a refresh for every 1, 6, 12, or 24 hours, or every day.
 */
public class RefreshScheduleFrequency private constructor(builder: Builder) {
    /**
     * The unit to use for the refresh.
     *
     * For custom dashboards, the unit can be `HOURS` or `DAYS`.
     *
     * For the Highlights dashboard, the `Unit` must be `HOURS`.
     */
    public val unit: aws.sdk.kotlin.services.cloudtrail.model.RefreshScheduleFrequencyUnit? = builder.unit
    /**
     * The value for the refresh schedule.
     *
     *  For custom dashboards, the following values are valid when the unit is `HOURS`: `1`, `6`, `12`, `24`
     *
     * For custom dashboards, the only valid value when the unit is `DAYS` is `1`.
     *
     * For the Highlights dashboard, the `Value` must be `6`.
     */
    public val value: kotlin.Int? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.RefreshScheduleFrequency = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RefreshScheduleFrequency(")
        append("unit=$unit,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = unit?.hashCode() ?: 0
        result = 31 * result + (value ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RefreshScheduleFrequency

        if (unit != other.unit) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.RefreshScheduleFrequency = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unit to use for the refresh.
         *
         * For custom dashboards, the unit can be `HOURS` or `DAYS`.
         *
         * For the Highlights dashboard, the `Unit` must be `HOURS`.
         */
        public var unit: aws.sdk.kotlin.services.cloudtrail.model.RefreshScheduleFrequencyUnit? = null
        /**
         * The value for the refresh schedule.
         *
         *  For custom dashboards, the following values are valid when the unit is `HOURS`: `1`, `6`, `12`, `24`
         *
         * For custom dashboards, the only valid value when the unit is `DAYS` is `1`.
         *
         * For the Highlights dashboard, the `Value` must be `6`.
         */
        public var value: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.RefreshScheduleFrequency) : this() {
            this.unit = x.unit
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.RefreshScheduleFrequency = RefreshScheduleFrequency(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
