// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Metadata about a query, such as the number of results.
 */
public class QueryStatistics private constructor(builder: Builder) {
    /**
     * The total bytes that the query scanned in the event data store. This value matches the number of bytes for which your account is billed for the query, unless the query is still running.
     */
    public val bytesScanned: kotlin.Long? = builder.bytesScanned
    /**
     * The number of results returned.
     */
    public val resultsCount: kotlin.Int? = builder.resultsCount
    /**
     * The total number of results returned by a query.
     */
    public val totalResultsCount: kotlin.Int? = builder.totalResultsCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.QueryStatistics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryStatistics(")
        append("bytesScanned=$bytesScanned,")
        append("resultsCount=$resultsCount,")
        append("totalResultsCount=$totalResultsCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bytesScanned?.hashCode() ?: 0
        result = 31 * result + (resultsCount ?: 0)
        result = 31 * result + (totalResultsCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryStatistics

        if (bytesScanned != other.bytesScanned) return false
        if (resultsCount != other.resultsCount) return false
        if (totalResultsCount != other.totalResultsCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.QueryStatistics = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The total bytes that the query scanned in the event data store. This value matches the number of bytes for which your account is billed for the query, unless the query is still running.
         */
        public var bytesScanned: kotlin.Long? = null
        /**
         * The number of results returned.
         */
        public var resultsCount: kotlin.Int? = null
        /**
         * The total number of results returned by a query.
         */
        public var totalResultsCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.QueryStatistics) : this() {
            this.bytesScanned = x.bytesScanned
            this.resultsCount = x.resultsCount
            this.totalResultsCount = x.totalResultsCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.QueryStatistics = QueryStatistics(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
