// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutResourcePolicyRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the CloudTrail event data store, dashboard, or channel attached to the resource-based policy.
     *
     * Example event data store ARN format: `arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE`
     *
     * Example dashboard ARN format: `arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash`
     *
     * Example channel ARN format: `arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890`
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * A JSON-formatted string for an Amazon Web Services resource-based policy.
     *
     *  For example resource-based policies, see [CloudTrail resource-based policy examples](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html) in the *CloudTrail User Guide*.
     */
    public val resourcePolicy: kotlin.String? = builder.resourcePolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.PutResourcePolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutResourcePolicyRequest(")
        append("resourceArn=$resourceArn,")
        append("resourcePolicy=$resourcePolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn?.hashCode() ?: 0
        result = 31 * result + (resourcePolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutResourcePolicyRequest

        if (resourceArn != other.resourceArn) return false
        if (resourcePolicy != other.resourcePolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.PutResourcePolicyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the CloudTrail event data store, dashboard, or channel attached to the resource-based policy.
         *
         * Example event data store ARN format: `arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE`
         *
         * Example dashboard ARN format: `arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash`
         *
         * Example channel ARN format: `arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890`
         */
        public var resourceArn: kotlin.String? = null
        /**
         * A JSON-formatted string for an Amazon Web Services resource-based policy.
         *
         *  For example resource-based policies, see [CloudTrail resource-based policy examples](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html) in the *CloudTrail User Guide*.
         */
        public var resourcePolicy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.PutResourcePolicyRequest) : this() {
            this.resourceArn = x.resourceArn
            this.resourcePolicy = x.resourcePolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.PutResourcePolicyRequest = PutResourcePolicyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
