// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutInsightSelectorsRequest private constructor(builder: Builder) {
    /**
     * The ARN (or ID suffix of the ARN) of the source event data store for which you want to change or add Insights selectors. To enable Insights on an event data store, you must provide both the `EventDataStore` and `InsightsDestination` parameters.
     *
     * You cannot use this parameter with the `TrailName` parameter.
     */
    public val eventDataStore: kotlin.String? = builder.eventDataStore
    /**
     * A JSON string that contains the Insights types you want to log on a trail or event data store. `ApiCallRateInsight` and `ApiErrorRateInsight` are valid Insight types.
     *
     * The `ApiCallRateInsight` Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.
     *
     * The `ApiErrorRateInsight` Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.
     */
    public val insightSelectors: List<InsightSelector>? = builder.insightSelectors
    /**
     * The ARN (or ID suffix of the ARN) of the destination event data store that logs Insights events. To enable Insights on an event data store, you must provide both the `EventDataStore` and `InsightsDestination` parameters.
     *
     * You cannot use this parameter with the `TrailName` parameter.
     */
    public val insightsDestination: kotlin.String? = builder.insightsDestination
    /**
     * The name of the CloudTrail trail for which you want to change or add Insights selectors.
     *
     * You cannot use this parameter with the `EventDataStore` and `InsightsDestination` parameters.
     */
    public val trailName: kotlin.String? = builder.trailName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.PutInsightSelectorsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutInsightSelectorsRequest(")
        append("eventDataStore=$eventDataStore,")
        append("insightSelectors=$insightSelectors,")
        append("insightsDestination=$insightsDestination,")
        append("trailName=$trailName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventDataStore?.hashCode() ?: 0
        result = 31 * result + (insightSelectors?.hashCode() ?: 0)
        result = 31 * result + (insightsDestination?.hashCode() ?: 0)
        result = 31 * result + (trailName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutInsightSelectorsRequest

        if (eventDataStore != other.eventDataStore) return false
        if (insightSelectors != other.insightSelectors) return false
        if (insightsDestination != other.insightsDestination) return false
        if (trailName != other.trailName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.PutInsightSelectorsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN (or ID suffix of the ARN) of the source event data store for which you want to change or add Insights selectors. To enable Insights on an event data store, you must provide both the `EventDataStore` and `InsightsDestination` parameters.
         *
         * You cannot use this parameter with the `TrailName` parameter.
         */
        public var eventDataStore: kotlin.String? = null
        /**
         * A JSON string that contains the Insights types you want to log on a trail or event data store. `ApiCallRateInsight` and `ApiErrorRateInsight` are valid Insight types.
         *
         * The `ApiCallRateInsight` Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.
         *
         * The `ApiErrorRateInsight` Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.
         */
        public var insightSelectors: List<InsightSelector>? = null
        /**
         * The ARN (or ID suffix of the ARN) of the destination event data store that logs Insights events. To enable Insights on an event data store, you must provide both the `EventDataStore` and `InsightsDestination` parameters.
         *
         * You cannot use this parameter with the `TrailName` parameter.
         */
        public var insightsDestination: kotlin.String? = null
        /**
         * The name of the CloudTrail trail for which you want to change or add Insights selectors.
         *
         * You cannot use this parameter with the `EventDataStore` and `InsightsDestination` parameters.
         */
        public var trailName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.PutInsightSelectorsRequest) : this() {
            this.eventDataStore = x.eventDataStore
            this.insightSelectors = x.insightSelectors
            this.insightsDestination = x.insightsDestination
            this.trailName = x.trailName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.PutInsightSelectorsRequest = PutInsightSelectorsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
