// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A JSON string that contains a list of Insights types that are logged on a trail or event data store.
 */
public class InsightSelector private constructor(builder: Builder) {
    /**
     * The type of Insights events to log on a trail or event data store. `ApiCallRateInsight` and `ApiErrorRateInsight` are valid Insight types.
     *
     * The `ApiCallRateInsight` Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.
     *
     * The `ApiErrorRateInsight` Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.
     */
    public val insightType: aws.sdk.kotlin.services.cloudtrail.model.InsightType? = builder.insightType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.InsightSelector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InsightSelector(")
        append("insightType=$insightType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = insightType?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InsightSelector

        if (insightType != other.insightType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.InsightSelector = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of Insights events to log on a trail or event data store. `ApiCallRateInsight` and `ApiErrorRateInsight` are valid Insight types.
         *
         * The `ApiCallRateInsight` Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.
         *
         * The `ApiErrorRateInsight` Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.
         */
        public var insightType: aws.sdk.kotlin.services.cloudtrail.model.InsightType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.InsightSelector) : this() {
            this.insightType = x.insightType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.InsightSelector = InsightSelector(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
