// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides statistics for the specified `ImportID`. CloudTrail does not update import statistics in real-time. Returned values for parameters such as `EventsCompleted` may be lower than the actual value, because CloudTrail updates statistics incrementally over the course of the import.
 */
public class ImportStatistics private constructor(builder: Builder) {
    /**
     * The number of trail events imported into the event data store.
     */
    public val eventsCompleted: kotlin.Long? = builder.eventsCompleted
    /**
     * The number of failed entries.
     */
    public val failedEntries: kotlin.Long? = builder.failedEntries
    /**
     * The number of log files that completed import.
     */
    public val filesCompleted: kotlin.Long? = builder.filesCompleted
    /**
     * The number of S3 prefixes that completed import.
     */
    public val prefixesCompleted: kotlin.Long? = builder.prefixesCompleted
    /**
     * The number of S3 prefixes found for the import.
     */
    public val prefixesFound: kotlin.Long? = builder.prefixesFound

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.ImportStatistics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportStatistics(")
        append("eventsCompleted=$eventsCompleted,")
        append("failedEntries=$failedEntries,")
        append("filesCompleted=$filesCompleted,")
        append("prefixesCompleted=$prefixesCompleted,")
        append("prefixesFound=$prefixesFound")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventsCompleted?.hashCode() ?: 0
        result = 31 * result + (failedEntries?.hashCode() ?: 0)
        result = 31 * result + (filesCompleted?.hashCode() ?: 0)
        result = 31 * result + (prefixesCompleted?.hashCode() ?: 0)
        result = 31 * result + (prefixesFound?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportStatistics

        if (eventsCompleted != other.eventsCompleted) return false
        if (failedEntries != other.failedEntries) return false
        if (filesCompleted != other.filesCompleted) return false
        if (prefixesCompleted != other.prefixesCompleted) return false
        if (prefixesFound != other.prefixesFound) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.ImportStatistics = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of trail events imported into the event data store.
         */
        public var eventsCompleted: kotlin.Long? = null
        /**
         * The number of failed entries.
         */
        public var failedEntries: kotlin.Long? = null
        /**
         * The number of log files that completed import.
         */
        public var filesCompleted: kotlin.Long? = null
        /**
         * The number of S3 prefixes that completed import.
         */
        public var prefixesCompleted: kotlin.Long? = null
        /**
         * The number of S3 prefixes found for the import.
         */
        public var prefixesFound: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.ImportStatistics) : this() {
            this.eventsCompleted = x.eventsCompleted
            this.failedEntries = x.failedEntries
            this.filesCompleted = x.filesCompleted
            this.prefixesCompleted = x.prefixesCompleted
            this.prefixesFound = x.prefixesFound
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.ImportStatistics = ImportStatistics(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
