// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A storage lake of event data against which you can run complex SQL-based queries. An event data store can include events that you have logged on your account. To select events for an event data store, use [advanced event selectors](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-concepts.html#adv-event-selectors).
 */
public class EventDataStore private constructor(builder: Builder) {
    /**
     * The advanced event selectors that were used to select events for the data store.
     */
    @Deprecated("AdvancedEventSelectors is no longer returned by ListEventDataStores")
    public val advancedEventSelectors: List<AdvancedEventSelector>? = builder.advancedEventSelectors
    /**
     * The timestamp of the event data store's creation.
     */
    @Deprecated("CreatedTimestamp is no longer returned by ListEventDataStores")
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The ARN of the event data store.
     */
    public val eventDataStoreArn: kotlin.String? = builder.eventDataStoreArn
    /**
     * Indicates whether the event data store includes events from all Regions, or only from the Region in which it was created.
     */
    @Deprecated("MultiRegionEnabled is no longer returned by ListEventDataStores")
    public val multiRegionEnabled: kotlin.Boolean? = builder.multiRegionEnabled
    /**
     * The name of the event data store.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Indicates that an event data store is collecting logged events for an organization.
     */
    @Deprecated("OrganizationEnabled is no longer returned by ListEventDataStores")
    public val organizationEnabled: kotlin.Boolean? = builder.organizationEnabled
    /**
     * The retention period, in days.
     */
    @Deprecated("RetentionPeriod is no longer returned by ListEventDataStores")
    public val retentionPeriod: kotlin.Int? = builder.retentionPeriod
    /**
     * The status of an event data store.
     */
    @Deprecated("Status is no longer returned by ListEventDataStores")
    public val status: aws.sdk.kotlin.services.cloudtrail.model.EventDataStoreStatus? = builder.status
    /**
     * Indicates whether the event data store is protected from termination.
     */
    @Deprecated("TerminationProtectionEnabled is no longer returned by ListEventDataStores")
    public val terminationProtectionEnabled: kotlin.Boolean? = builder.terminationProtectionEnabled
    /**
     * The timestamp showing when an event data store was updated, if applicable. `UpdatedTimestamp` is always either the same or newer than the time shown in `CreatedTimestamp`.
     */
    @Deprecated("UpdatedTimestamp is no longer returned by ListEventDataStores")
    public val updatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedTimestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.EventDataStore = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventDataStore(")
        append("advancedEventSelectors=$advancedEventSelectors,")
        append("createdTimestamp=$createdTimestamp,")
        append("eventDataStoreArn=$eventDataStoreArn,")
        append("multiRegionEnabled=$multiRegionEnabled,")
        append("name=$name,")
        append("organizationEnabled=$organizationEnabled,")
        append("retentionPeriod=$retentionPeriod,")
        append("status=$status,")
        append("terminationProtectionEnabled=$terminationProtectionEnabled,")
        append("updatedTimestamp=$updatedTimestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = advancedEventSelectors?.hashCode() ?: 0
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (eventDataStoreArn?.hashCode() ?: 0)
        result = 31 * result + (multiRegionEnabled?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (organizationEnabled?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (terminationProtectionEnabled?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventDataStore

        if (advancedEventSelectors != other.advancedEventSelectors) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (eventDataStoreArn != other.eventDataStoreArn) return false
        if (multiRegionEnabled != other.multiRegionEnabled) return false
        if (name != other.name) return false
        if (organizationEnabled != other.organizationEnabled) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (status != other.status) return false
        if (terminationProtectionEnabled != other.terminationProtectionEnabled) return false
        if (updatedTimestamp != other.updatedTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.EventDataStore = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The advanced event selectors that were used to select events for the data store.
         */
        @Deprecated("AdvancedEventSelectors is no longer returned by ListEventDataStores")
        public var advancedEventSelectors: List<AdvancedEventSelector>? = null
        /**
         * The timestamp of the event data store's creation.
         */
        @Deprecated("CreatedTimestamp is no longer returned by ListEventDataStores")
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the event data store.
         */
        public var eventDataStoreArn: kotlin.String? = null
        /**
         * Indicates whether the event data store includes events from all Regions, or only from the Region in which it was created.
         */
        @Deprecated("MultiRegionEnabled is no longer returned by ListEventDataStores")
        public var multiRegionEnabled: kotlin.Boolean? = null
        /**
         * The name of the event data store.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates that an event data store is collecting logged events for an organization.
         */
        @Deprecated("OrganizationEnabled is no longer returned by ListEventDataStores")
        public var organizationEnabled: kotlin.Boolean? = null
        /**
         * The retention period, in days.
         */
        @Deprecated("RetentionPeriod is no longer returned by ListEventDataStores")
        public var retentionPeriod: kotlin.Int? = null
        /**
         * The status of an event data store.
         */
        @Deprecated("Status is no longer returned by ListEventDataStores")
        public var status: aws.sdk.kotlin.services.cloudtrail.model.EventDataStoreStatus? = null
        /**
         * Indicates whether the event data store is protected from termination.
         */
        @Deprecated("TerminationProtectionEnabled is no longer returned by ListEventDataStores")
        public var terminationProtectionEnabled: kotlin.Boolean? = null
        /**
         * The timestamp showing when an event data store was updated, if applicable. `UpdatedTimestamp` is always either the same or newer than the time shown in `CreatedTimestamp`.
         */
        @Deprecated("UpdatedTimestamp is no longer returned by ListEventDataStores")
        public var updatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.EventDataStore) : this() {
            this.advancedEventSelectors = x.advancedEventSelectors
            this.createdTimestamp = x.createdTimestamp
            this.eventDataStoreArn = x.eventDataStoreArn
            this.multiRegionEnabled = x.multiRegionEnabled
            this.name = x.name
            this.organizationEnabled = x.organizationEnabled
            this.retentionPeriod = x.retentionPeriod
            this.status = x.status
            this.terminationProtectionEnabled = x.terminationProtectionEnabled
            this.updatedTimestamp = x.updatedTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.EventDataStore = EventDataStore(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
