// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about the destination receiving events.
 */
public class Destination private constructor(builder: Builder) {
    /**
     * For channels used for a CloudTrail Lake integration, the location is the ARN of an event data store that receives events from a channel. For service-linked channels, the location is the name of the Amazon Web Services service.
     */
    public val location: kotlin.String = requireNotNull(builder.location) { "A non-null value must be provided for location" }
    /**
     * The type of destination for events arriving from a channel. For channels used for a CloudTrail Lake integration, the value is `EVENT_DATA_STORE`. For service-linked channels, the value is `AWS_SERVICE`.
     */
    public val type: aws.sdk.kotlin.services.cloudtrail.model.DestinationType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.Destination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Destination(")
        append("location=$location,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = location.hashCode()
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Destination

        if (location != other.location) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.Destination = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * For channels used for a CloudTrail Lake integration, the location is the ARN of an event data store that receives events from a channel. For service-linked channels, the location is the name of the Amazon Web Services service.
         */
        public var location: kotlin.String? = null
        /**
         * The type of destination for events arriving from a channel. For channels used for a CloudTrail Lake integration, the value is `EVENT_DATA_STORE`. For service-linked channels, the value is `AWS_SERVICE`.
         */
        public var type: aws.sdk.kotlin.services.cloudtrail.model.DestinationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.Destination) : this() {
            this.location = x.location
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.Destination = Destination(this)

        internal fun correctErrors(): Builder {
            if (location == null) location = ""
            if (type == null) type = DestinationType.SdkUnknown("no value provided")
            return this
        }
    }
}
