// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Returns information about the trail.
 */
public class DescribeTrailsRequest private constructor(builder: Builder) {
    /**
     * Specifies whether to include shadow trails in the response. A shadow trail is the replication in a Region of a trail that was created in a different Region, or in the case of an organization trail, the replication of an organization trail in member accounts. If you do not include shadow trails, organization trails in a member account and Region replication trails will not be returned. The default is true.
     */
    public val includeShadowTrails: kotlin.Boolean? = builder.includeShadowTrails
    /**
     * Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is:
     *
     * `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
     *
     * If an empty list is specified, information for the trail in the current Region is returned.
     * + If an empty list is specified and `IncludeShadowTrails` is false, then information for all trails in the current Region is returned.
     * + If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the current Region and any associated shadow trails in other Regions is returned.
     *
     * If one or more trail names are specified, information is returned only if the names match the names of trails belonging only to the current Region and current account. To return information about a trail in another Region, you must specify its trail ARN.
     */
    public val trailNameList: List<String>? = builder.trailNameList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.DescribeTrailsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTrailsRequest(")
        append("includeShadowTrails=$includeShadowTrails,")
        append("trailNameList=$trailNameList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = includeShadowTrails?.hashCode() ?: 0
        result = 31 * result + (trailNameList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTrailsRequest

        if (includeShadowTrails != other.includeShadowTrails) return false
        if (trailNameList != other.trailNameList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.DescribeTrailsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether to include shadow trails in the response. A shadow trail is the replication in a Region of a trail that was created in a different Region, or in the case of an organization trail, the replication of an organization trail in member accounts. If you do not include shadow trails, organization trails in a member account and Region replication trails will not be returned. The default is true.
         */
        public var includeShadowTrails: kotlin.Boolean? = null
        /**
         * Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is:
         *
         * `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
         *
         * If an empty list is specified, information for the trail in the current Region is returned.
         * + If an empty list is specified and `IncludeShadowTrails` is false, then information for all trails in the current Region is returned.
         * + If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the current Region and any associated shadow trails in other Regions is returned.
         *
         * If one or more trail names are specified, information is returned only if the names match the names of trails belonging only to the current Region and current account. To return information about a trail in another Region, you must specify its trail ARN.
         */
        public var trailNameList: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.DescribeTrailsRequest) : this() {
            this.includeShadowTrails = x.includeShadowTrails
            this.trailNameList = x.trailNameList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.DescribeTrailsRequest = DescribeTrailsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
