// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A single selector statement in an advanced event selector.
 */
public class AdvancedFieldSelector private constructor(builder: Builder) {
    /**
     * An operator that includes events that match the last few characters of the event record field specified as the value of `Field`.
     */
    public val endsWith: List<String>? = builder.endsWith
    /**
     * An operator that includes events that match the exact value of the event record field specified as the value of `Field`. This is the only valid operator that you can use with the `readOnly`, `eventCategory`, and `resources.type` fields.
     */
    public val equals: List<String>? = builder.equals
    /**
     * A field in a CloudTrail event record on which to filter events to be logged. For event data stores for CloudTrail Insights events, Config configuration items, Audit Manager evidence, or events outside of Amazon Web Services, the field is used only for selecting events as filtering is not supported.
     *
     * For more information, see [AdvancedFieldSelector](https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedFieldSelector.html) in the *CloudTrail API Reference*.
     *
     * Selectors don't support the use of wildcards like `*` . To match multiple values with a single condition, you may use `StartsWith`, `EndsWith`, `NotStartsWith`, or `NotEndsWith` to explicitly match the beginning or end of the event field.
     */
    public val field: kotlin.String = requireNotNull(builder.field) { "A non-null value must be provided for field" }
    /**
     * An operator that excludes events that match the last few characters of the event record field specified as the value of `Field`.
     */
    public val notEndsWith: List<String>? = builder.notEndsWith
    /**
     * An operator that excludes events that match the exact value of the event record field specified as the value of `Field`.
     */
    public val notEquals: List<String>? = builder.notEquals
    /**
     * An operator that excludes events that match the first few characters of the event record field specified as the value of `Field`.
     */
    public val notStartsWith: List<String>? = builder.notStartsWith
    /**
     * An operator that includes events that match the first few characters of the event record field specified as the value of `Field`.
     */
    public val startsWith: List<String>? = builder.startsWith

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.AdvancedFieldSelector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdvancedFieldSelector(")
        append("endsWith=$endsWith,")
        append("equals=$equals,")
        append("field=$field,")
        append("notEndsWith=$notEndsWith,")
        append("notEquals=$notEquals,")
        append("notStartsWith=$notStartsWith,")
        append("startsWith=$startsWith")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endsWith?.hashCode() ?: 0
        result = 31 * result + (equals?.hashCode() ?: 0)
        result = 31 * result + (field.hashCode())
        result = 31 * result + (notEndsWith?.hashCode() ?: 0)
        result = 31 * result + (notEquals?.hashCode() ?: 0)
        result = 31 * result + (notStartsWith?.hashCode() ?: 0)
        result = 31 * result + (startsWith?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdvancedFieldSelector

        if (endsWith != other.endsWith) return false
        if (equals != other.equals) return false
        if (field != other.field) return false
        if (notEndsWith != other.notEndsWith) return false
        if (notEquals != other.notEquals) return false
        if (notStartsWith != other.notStartsWith) return false
        if (startsWith != other.startsWith) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.AdvancedFieldSelector = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An operator that includes events that match the last few characters of the event record field specified as the value of `Field`.
         */
        public var endsWith: List<String>? = null
        /**
         * An operator that includes events that match the exact value of the event record field specified as the value of `Field`. This is the only valid operator that you can use with the `readOnly`, `eventCategory`, and `resources.type` fields.
         */
        public var equals: List<String>? = null
        /**
         * A field in a CloudTrail event record on which to filter events to be logged. For event data stores for CloudTrail Insights events, Config configuration items, Audit Manager evidence, or events outside of Amazon Web Services, the field is used only for selecting events as filtering is not supported.
         *
         * For more information, see [AdvancedFieldSelector](https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedFieldSelector.html) in the *CloudTrail API Reference*.
         *
         * Selectors don't support the use of wildcards like `*` . To match multiple values with a single condition, you may use `StartsWith`, `EndsWith`, `NotStartsWith`, or `NotEndsWith` to explicitly match the beginning or end of the event field.
         */
        public var field: kotlin.String? = null
        /**
         * An operator that excludes events that match the last few characters of the event record field specified as the value of `Field`.
         */
        public var notEndsWith: List<String>? = null
        /**
         * An operator that excludes events that match the exact value of the event record field specified as the value of `Field`.
         */
        public var notEquals: List<String>? = null
        /**
         * An operator that excludes events that match the first few characters of the event record field specified as the value of `Field`.
         */
        public var notStartsWith: List<String>? = null
        /**
         * An operator that includes events that match the first few characters of the event record field specified as the value of `Field`.
         */
        public var startsWith: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.AdvancedFieldSelector) : this() {
            this.endsWith = x.endsWith
            this.equals = x.equals
            this.field = x.field
            this.notEndsWith = x.notEndsWith
            this.notEquals = x.notEquals
            this.notStartsWith = x.notStartsWith
            this.startsWith = x.startsWith
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.AdvancedFieldSelector = AdvancedFieldSelector(this)

        internal fun correctErrors(): Builder {
            if (field == null) field = ""
            return this
        }
    }
}
