// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Advanced event selectors let you create fine-grained selectors for CloudTrail management, data, and network activity events. They help you control costs by logging only those events that are important to you. For more information about configuring advanced event selectors, see the [Logging data events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html), [Logging network activity events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html), and [Logging management events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html) topics in the *CloudTrail User Guide*.
 *
 * You cannot apply both event selectors and advanced event selectors to a trail.
 *
 * For information about configurable advanced event selector fields, see [AdvancedEventSelector](https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html) in the *CloudTrail API Reference*.
 */
public class AdvancedEventSelector private constructor(builder: Builder) {
    /**
     * Contains all selector statements in an advanced event selector.
     */
    public val fieldSelectors: List<AdvancedFieldSelector> = requireNotNull(builder.fieldSelectors) { "A non-null value must be provided for fieldSelectors" }
    /**
     * An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.AdvancedEventSelector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdvancedEventSelector(")
        append("fieldSelectors=$fieldSelectors,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fieldSelectors.hashCode()
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdvancedEventSelector

        if (fieldSelectors != other.fieldSelectors) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.AdvancedEventSelector = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Contains all selector statements in an advanced event selector.
         */
        public var fieldSelectors: List<AdvancedFieldSelector>? = null
        /**
         * An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.AdvancedEventSelector) : this() {
            this.fieldSelectors = x.fieldSelectors
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.AdvancedEventSelector = AdvancedEventSelector(this)

        internal fun correctErrors(): Builder {
            if (fieldSelectors == null) fieldSelectors = emptyList()
            return this
        }
    }
}
