// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the tags to add to a trail, event data store, dashboard, or channel.
 */
public class AddTagsRequest private constructor(builder: Builder) {
    /**
     * Specifies the ARN of the trail, event data store, dashboard, or channel to which one or more tags will be added.
     *
     * The format of a trail ARN is: `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
     *
     * The format of an event data store ARN is: `arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE`
     *
     * The format of a dashboard ARN is: `arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash`
     *
     * The format of a channel ARN is: `arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890`
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * Contains a list of tags, up to a limit of 50
     */
    public val tagsList: List<Tag>? = builder.tagsList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.AddTagsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddTagsRequest(")
        append("resourceId=$resourceId,")
        append("tagsList=$tagsList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceId?.hashCode() ?: 0
        result = 31 * result + (tagsList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddTagsRequest

        if (resourceId != other.resourceId) return false
        if (tagsList != other.tagsList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.AddTagsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the ARN of the trail, event data store, dashboard, or channel to which one or more tags will be added.
         *
         * The format of a trail ARN is: `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
         *
         * The format of an event data store ARN is: `arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE`
         *
         * The format of a dashboard ARN is: `arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash`
         *
         * The format of a channel ARN is: `arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890`
         */
        public var resourceId: kotlin.String? = null
        /**
         * Contains a list of tags, up to a limit of 50
         */
        public var tagsList: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.AddTagsRequest) : this() {
            this.resourceId = x.resourceId
            this.tagsList = x.tagsList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.AddTagsRequest = AddTagsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
