// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.cloudtrail.auth.CloudTrailAuthSchemeProvider
import aws.sdk.kotlin.services.cloudtrail.auth.DefaultCloudTrailAuthSchemeProvider
import aws.sdk.kotlin.services.cloudtrail.endpoints.CloudTrailEndpointParameters
import aws.sdk.kotlin.services.cloudtrail.endpoints.CloudTrailEndpointProvider
import aws.sdk.kotlin.services.cloudtrail.endpoints.DefaultCloudTrailEndpointProvider
import aws.sdk.kotlin.services.cloudtrail.model.AddTagsRequest
import aws.sdk.kotlin.services.cloudtrail.model.AddTagsResponse
import aws.sdk.kotlin.services.cloudtrail.model.CancelQueryRequest
import aws.sdk.kotlin.services.cloudtrail.model.CancelQueryResponse
import aws.sdk.kotlin.services.cloudtrail.model.CreateChannelRequest
import aws.sdk.kotlin.services.cloudtrail.model.CreateChannelResponse
import aws.sdk.kotlin.services.cloudtrail.model.CreateDashboardRequest
import aws.sdk.kotlin.services.cloudtrail.model.CreateDashboardResponse
import aws.sdk.kotlin.services.cloudtrail.model.CreateEventDataStoreRequest
import aws.sdk.kotlin.services.cloudtrail.model.CreateEventDataStoreResponse
import aws.sdk.kotlin.services.cloudtrail.model.CreateTrailRequest
import aws.sdk.kotlin.services.cloudtrail.model.CreateTrailResponse
import aws.sdk.kotlin.services.cloudtrail.model.DeleteChannelRequest
import aws.sdk.kotlin.services.cloudtrail.model.DeleteChannelResponse
import aws.sdk.kotlin.services.cloudtrail.model.DeleteDashboardRequest
import aws.sdk.kotlin.services.cloudtrail.model.DeleteDashboardResponse
import aws.sdk.kotlin.services.cloudtrail.model.DeleteEventDataStoreRequest
import aws.sdk.kotlin.services.cloudtrail.model.DeleteEventDataStoreResponse
import aws.sdk.kotlin.services.cloudtrail.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.cloudtrail.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.cloudtrail.model.DeleteTrailRequest
import aws.sdk.kotlin.services.cloudtrail.model.DeleteTrailResponse
import aws.sdk.kotlin.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminRequest
import aws.sdk.kotlin.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminResponse
import aws.sdk.kotlin.services.cloudtrail.model.DescribeQueryRequest
import aws.sdk.kotlin.services.cloudtrail.model.DescribeQueryResponse
import aws.sdk.kotlin.services.cloudtrail.model.DescribeTrailsRequest
import aws.sdk.kotlin.services.cloudtrail.model.DescribeTrailsResponse
import aws.sdk.kotlin.services.cloudtrail.model.DisableFederationRequest
import aws.sdk.kotlin.services.cloudtrail.model.DisableFederationResponse
import aws.sdk.kotlin.services.cloudtrail.model.EnableFederationRequest
import aws.sdk.kotlin.services.cloudtrail.model.EnableFederationResponse
import aws.sdk.kotlin.services.cloudtrail.model.GenerateQueryRequest
import aws.sdk.kotlin.services.cloudtrail.model.GenerateQueryResponse
import aws.sdk.kotlin.services.cloudtrail.model.GetChannelRequest
import aws.sdk.kotlin.services.cloudtrail.model.GetChannelResponse
import aws.sdk.kotlin.services.cloudtrail.model.GetDashboardRequest
import aws.sdk.kotlin.services.cloudtrail.model.GetDashboardResponse
import aws.sdk.kotlin.services.cloudtrail.model.GetEventConfigurationRequest
import aws.sdk.kotlin.services.cloudtrail.model.GetEventConfigurationResponse
import aws.sdk.kotlin.services.cloudtrail.model.GetEventDataStoreRequest
import aws.sdk.kotlin.services.cloudtrail.model.GetEventDataStoreResponse
import aws.sdk.kotlin.services.cloudtrail.model.GetEventSelectorsRequest
import aws.sdk.kotlin.services.cloudtrail.model.GetEventSelectorsResponse
import aws.sdk.kotlin.services.cloudtrail.model.GetImportRequest
import aws.sdk.kotlin.services.cloudtrail.model.GetImportResponse
import aws.sdk.kotlin.services.cloudtrail.model.GetInsightSelectorsRequest
import aws.sdk.kotlin.services.cloudtrail.model.GetInsightSelectorsResponse
import aws.sdk.kotlin.services.cloudtrail.model.GetQueryResultsRequest
import aws.sdk.kotlin.services.cloudtrail.model.GetQueryResultsResponse
import aws.sdk.kotlin.services.cloudtrail.model.GetResourcePolicyRequest
import aws.sdk.kotlin.services.cloudtrail.model.GetResourcePolicyResponse
import aws.sdk.kotlin.services.cloudtrail.model.GetTrailRequest
import aws.sdk.kotlin.services.cloudtrail.model.GetTrailResponse
import aws.sdk.kotlin.services.cloudtrail.model.GetTrailStatusRequest
import aws.sdk.kotlin.services.cloudtrail.model.GetTrailStatusResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListChannelsRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListChannelsResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListDashboardsRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListDashboardsResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListEventDataStoresRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListEventDataStoresResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListImportFailuresRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListImportFailuresResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListImportsRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListImportsResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListInsightsMetricDataRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListInsightsMetricDataResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListPublicKeysRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListPublicKeysResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListQueriesRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListQueriesResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListTagsRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListTagsResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListTrailsRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListTrailsResponse
import aws.sdk.kotlin.services.cloudtrail.model.LookupEventsRequest
import aws.sdk.kotlin.services.cloudtrail.model.LookupEventsResponse
import aws.sdk.kotlin.services.cloudtrail.model.PutEventConfigurationRequest
import aws.sdk.kotlin.services.cloudtrail.model.PutEventConfigurationResponse
import aws.sdk.kotlin.services.cloudtrail.model.PutEventSelectorsRequest
import aws.sdk.kotlin.services.cloudtrail.model.PutEventSelectorsResponse
import aws.sdk.kotlin.services.cloudtrail.model.PutInsightSelectorsRequest
import aws.sdk.kotlin.services.cloudtrail.model.PutInsightSelectorsResponse
import aws.sdk.kotlin.services.cloudtrail.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.cloudtrail.model.PutResourcePolicyResponse
import aws.sdk.kotlin.services.cloudtrail.model.RegisterOrganizationDelegatedAdminRequest
import aws.sdk.kotlin.services.cloudtrail.model.RegisterOrganizationDelegatedAdminResponse
import aws.sdk.kotlin.services.cloudtrail.model.RemoveTagsRequest
import aws.sdk.kotlin.services.cloudtrail.model.RemoveTagsResponse
import aws.sdk.kotlin.services.cloudtrail.model.RestoreEventDataStoreRequest
import aws.sdk.kotlin.services.cloudtrail.model.RestoreEventDataStoreResponse
import aws.sdk.kotlin.services.cloudtrail.model.SearchSampleQueriesRequest
import aws.sdk.kotlin.services.cloudtrail.model.SearchSampleQueriesResponse
import aws.sdk.kotlin.services.cloudtrail.model.StartDashboardRefreshRequest
import aws.sdk.kotlin.services.cloudtrail.model.StartDashboardRefreshResponse
import aws.sdk.kotlin.services.cloudtrail.model.StartEventDataStoreIngestionRequest
import aws.sdk.kotlin.services.cloudtrail.model.StartEventDataStoreIngestionResponse
import aws.sdk.kotlin.services.cloudtrail.model.StartImportRequest
import aws.sdk.kotlin.services.cloudtrail.model.StartImportResponse
import aws.sdk.kotlin.services.cloudtrail.model.StartLoggingRequest
import aws.sdk.kotlin.services.cloudtrail.model.StartLoggingResponse
import aws.sdk.kotlin.services.cloudtrail.model.StartQueryRequest
import aws.sdk.kotlin.services.cloudtrail.model.StartQueryResponse
import aws.sdk.kotlin.services.cloudtrail.model.StopEventDataStoreIngestionRequest
import aws.sdk.kotlin.services.cloudtrail.model.StopEventDataStoreIngestionResponse
import aws.sdk.kotlin.services.cloudtrail.model.StopImportRequest
import aws.sdk.kotlin.services.cloudtrail.model.StopImportResponse
import aws.sdk.kotlin.services.cloudtrail.model.StopLoggingRequest
import aws.sdk.kotlin.services.cloudtrail.model.StopLoggingResponse
import aws.sdk.kotlin.services.cloudtrail.model.UpdateChannelRequest
import aws.sdk.kotlin.services.cloudtrail.model.UpdateChannelResponse
import aws.sdk.kotlin.services.cloudtrail.model.UpdateDashboardRequest
import aws.sdk.kotlin.services.cloudtrail.model.UpdateDashboardResponse
import aws.sdk.kotlin.services.cloudtrail.model.UpdateEventDataStoreRequest
import aws.sdk.kotlin.services.cloudtrail.model.UpdateEventDataStoreResponse
import aws.sdk.kotlin.services.cloudtrail.model.UpdateTrailRequest
import aws.sdk.kotlin.services.cloudtrail.model.UpdateTrailResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "CloudTrail"
public const val SdkVersion: String = "1.5.5"
public const val ServiceApiVersion: String = "2013-11-01"

/**
 * # CloudTrail
 * This is the CloudTrail API Reference. It provides descriptions of actions, data types, common parameters, and common errors for CloudTrail.
 *
 * CloudTrail is a web service that records Amazon Web Services API calls for your Amazon Web Services account and delivers log files to an Amazon S3 bucket. The recorded information includes the identity of the user, the start time of the Amazon Web Services API call, the source IP address, the request parameters, and the response elements returned by the service.
 *
 * As an alternative to the API, you can use one of the Amazon Web Services SDKs, which consist of libraries and sample code for various programming languages and platforms (Java, Ruby, .NET, iOS, Android, etc.). The SDKs provide programmatic access to CloudTrail. For example, the SDKs handle cryptographically signing requests, managing errors, and retrying requests automatically. For more information about the Amazon Web Services SDKs, including how to download and install them, see [Tools to Build on Amazon Web Services](http://aws.amazon.com/tools/).
 *
 * See the [CloudTrail User Guide](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-user-guide.html) for information about the data that is included with each Amazon Web Services API call listed in the log files.
 */
public interface CloudTrailClient : SdkClient {
    /**
     * CloudTrailClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CloudTrailClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "CloudTrail",
                "CLOUDTRAIL",
                "cloudtrail",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CloudTrailClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CloudTrailClient = DefaultCloudTrailClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: CloudTrailEndpointProvider = builder.endpointProvider ?: DefaultCloudTrailEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: CloudTrailAuthSchemeProvider = builder.authSchemeProvider ?: DefaultCloudTrailAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "CloudTrail"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: CloudTrailEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: CloudTrailAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds one or more tags to a trail, event data store, dashboard, or channel, up to a limit of 50. Overwrites an existing tag's value when a new value is specified for an existing tag key. Tag key names must be unique; you cannot have two keys with the same name but different values. If you specify a key without a value, the tag will be created with the specified key and a value of null. You can tag a trail or event data store that applies to all Amazon Web Services Regions only from the Region in which the trail or event data store was created (also known as its home Region).
     */
    public suspend fun addTags(input: AddTagsRequest): AddTagsResponse

    /**
     * Cancels a query if the query is not in a terminated state, such as `CANCELLED`, `FAILED`, `TIMED_OUT`, or `FINISHED`. You must specify an ARN value for `EventDataStore`. The ID of the query that you want to cancel is also required. When you run `CancelQuery`, the query status might show as `CANCELLED` even if the operation is not yet finished.
     */
    public suspend fun cancelQuery(input: CancelQueryRequest): CancelQueryResponse

    /**
     * Creates a channel for CloudTrail to ingest events from a partner or external source. After you create a channel, a CloudTrail Lake event data store can log events from the partner or source that you specify.
     */
    public suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse

    /**
     * Creates a custom dashboard or the Highlights dashboard.
     * + **Custom dashboards** - Custom dashboards allow you to query events in any event data store type. You can add up to 10 widgets to a custom dashboard. You can manually refresh a custom dashboard, or you can set a refresh schedule.
     * + **Highlights dashboard** - You can create the Highlights dashboard to see a summary of key user activities and API usage across all your event data stores. CloudTrail Lake manages the Highlights dashboard and refreshes the dashboard every 6 hours. To create the Highlights dashboard, you must set and enable a refresh schedule.
     *
     *  CloudTrail runs queries to populate the dashboard's widgets during a manual or scheduled refresh. CloudTrail must be granted permissions to run the `StartQuery` operation on your behalf. To provide permissions, run the `PutResourcePolicy` operation to attach a resource-based policy to each event data store. For more information, see [Example: Allow CloudTrail to run queries to populate a dashboard](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard) in the *CloudTrail User Guide*.
     *
     *  To set a refresh schedule, CloudTrail must be granted permissions to run the `StartDashboardRefresh` operation to refresh the dashboard on your behalf. To provide permissions, run the `PutResourcePolicy` operation to attach a resource-based policy to the dashboard. For more information, see [ Resource-based policy example for a dashboard](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-dashboards) in the *CloudTrail User Guide*.
     *
     * For more information about dashboards, see [CloudTrail Lake dashboards](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-dashboard.html) in the *CloudTrail User Guide*.
     */
    public suspend fun createDashboard(input: CreateDashboardRequest): CreateDashboardResponse

    /**
     * Creates a new event data store.
     */
    public suspend fun createEventDataStore(input: CreateEventDataStoreRequest): CreateEventDataStoreResponse

    /**
     * Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
     */
    public suspend fun createTrail(input: CreateTrailRequest): CreateTrailResponse

    /**
     * Deletes a channel.
     */
    public suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * Deletes the specified dashboard. You cannot delete a dashboard that has termination protection enabled.
     */
    public suspend fun deleteDashboard(input: DeleteDashboardRequest): DeleteDashboardResponse

    /**
     * Disables the event data store specified by `EventDataStore`, which accepts an event data store ARN. After you run `DeleteEventDataStore`, the event data store enters a `PENDING_DELETION` state, and is automatically deleted after a wait period of seven days. `TerminationProtectionEnabled` must be set to `False` on the event data store and the `FederationStatus` must be `DISABLED`. You cannot delete an event data store if `TerminationProtectionEnabled` is `True` or the `FederationStatus` is `ENABLED`.
     *
     * After you run `DeleteEventDataStore` on an event data store, you cannot run `ListQueries`, `DescribeQuery`, or `GetQueryResults` on queries that are using an event data store in a `PENDING_DELETION` state. An event data store in the `PENDING_DELETION` state does not incur costs.
     */
    public suspend fun deleteEventDataStore(input: DeleteEventDataStoreRequest): DeleteEventDataStoreResponse

    /**
     * Deletes the resource-based policy attached to the CloudTrail event data store, dashboard, or channel.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes a trail. This operation must be called from the Region in which the trail was created. `DeleteTrail` cannot be called on the shadow trails (replicated trails in other Regions) of a trail that is enabled in all Regions.
     */
    public suspend fun deleteTrail(input: DeleteTrailRequest): DeleteTrailResponse

    /**
     * Removes CloudTrail delegated administrator permissions from a member account in an organization.
     */
    public suspend fun deregisterOrganizationDelegatedAdmin(input: DeregisterOrganizationDelegatedAdminRequest): DeregisterOrganizationDelegatedAdminResponse

    /**
     * Returns metadata about a query, including query run time in milliseconds, number of events scanned and matched, and query status. If the query results were delivered to an S3 bucket, the response also provides the S3 URI and the delivery status.
     *
     * You must specify either `QueryId` or `QueryAlias`. Specifying the `QueryAlias` parameter returns information about the last query run for the alias. You can provide `RefreshId` along with `QueryAlias` to view the query results of a dashboard query for the specified `RefreshId`.
     */
    public suspend fun describeQuery(input: DescribeQueryRequest = DescribeQueryRequest { }): DescribeQueryResponse

    /**
     * Retrieves settings for one or more trails associated with the current Region for your account.
     */
    public suspend fun describeTrails(input: DescribeTrailsRequest = DescribeTrailsRequest { }): DescribeTrailsResponse

    /**
     * Disables Lake query federation on the specified event data store. When you disable federation, CloudTrail disables the integration with Glue, Lake Formation, and Amazon Athena. After disabling Lake query federation, you can no longer query your event data in Amazon Athena.
     *
     * No CloudTrail Lake data is deleted when you disable federation and you can continue to run queries in CloudTrail Lake.
     */
    public suspend fun disableFederation(input: DisableFederationRequest): DisableFederationResponse

    /**
     * Enables Lake query federation on the specified event data store. Federating an event data store lets you view the metadata associated with the event data store in the Glue [Data Catalog](https://docs.aws.amazon.com/glue/latest/dg/components-overview.html#data-catalog-intro) and run SQL queries against your event data using Amazon Athena. The table metadata stored in the Glue Data Catalog lets the Athena query engine know how to find, read, and process the data that you want to query.
     *
     * When you enable Lake query federation, CloudTrail creates a managed database named `aws:cloudtrail` (if the database doesn't already exist) and a managed federated table in the Glue Data Catalog. The event data store ID is used for the table name. CloudTrail registers the role ARN and event data store in [Lake Formation](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation-lake-formation.html), the service responsible for allowing fine-grained access control of the federated resources in the Glue Data Catalog.
     *
     * For more information about Lake query federation, see [Federate an event data store](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html).
     */
    public suspend fun enableFederation(input: EnableFederationRequest): EnableFederationResponse

    /**
     * Generates a query from a natural language prompt. This operation uses generative artificial intelligence (generative AI) to produce a ready-to-use SQL query from the prompt.
     *
     * The prompt can be a question or a statement about the event data in your event data store. For example, you can enter prompts like "What are my top errors in the past month?" and “Give me a list of users that used SNS.”
     *
     * The prompt must be in English. For information about limitations, permissions, and supported Regions, see [Create CloudTrail Lake queries from natural language prompts](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-query-generator.html) in the *CloudTrail * user guide.
     *
     * Do not include any personally identifying, confidential, or sensitive information in your prompts.
     *
     * This feature uses generative AI large language models (LLMs); we recommend double-checking the LLM response.
     */
    public suspend fun generateQuery(input: GenerateQueryRequest): GenerateQueryResponse

    /**
     * Returns information about a specific channel.
     */
    public suspend fun getChannel(input: GetChannelRequest): GetChannelResponse

    /**
     * Returns the specified dashboard.
     */
    public suspend fun getDashboard(input: GetDashboardRequest): GetDashboardResponse

    /**
     * Retrieves the current event configuration settings for the specified event data store, including details about maximum event size and context key selectors configured for the event data store.
     */
    public suspend fun getEventConfiguration(input: GetEventConfigurationRequest = GetEventConfigurationRequest { }): GetEventConfigurationResponse

    /**
     * Returns information about an event data store specified as either an ARN or the ID portion of the ARN.
     */
    public suspend fun getEventDataStore(input: GetEventDataStoreRequest): GetEventDataStoreResponse

    /**
     * Describes the settings for the event selectors that you configured for your trail. The information returned for your event selectors includes the following:
     * + If your event selector includes read-only events, write-only events, or all events. This applies to management events, data events, and network activity events.
     * + If your event selector includes management events.
     * + If your event selector includes network activity events, the event sources for which you are logging network activity events.
     * + If your event selector includes data events, the resources on which you are logging data events.
     *
     * For more information about logging management, data, and network activity events, see the following topics in the *CloudTrail User Guide*:
     * + [Logging management events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html)
     * + [Logging data events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html)
     * + [Logging network activity events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html)
     */
    public suspend fun getEventSelectors(input: GetEventSelectorsRequest): GetEventSelectorsResponse

    /**
     * Returns information about a specific import.
     */
    public suspend fun getImport(input: GetImportRequest): GetImportResponse

    /**
     * Describes the settings for the Insights event selectors that you configured for your trail or event data store. `GetInsightSelectors` shows if CloudTrail Insights event logging is enabled on the trail or event data store, and if it is, which Insights types are enabled. If you run `GetInsightSelectors` on a trail or event data store that does not have Insights events enabled, the operation throws the exception `InsightNotEnabledException`
     *
     * Specify either the `EventDataStore` parameter to get Insights event selectors for an event data store, or the `TrailName` parameter to the get Insights event selectors for a trail. You cannot specify these parameters together.
     *
     * For more information, see [Working with CloudTrail Insights](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
     */
    public suspend fun getInsightSelectors(input: GetInsightSelectorsRequest = GetInsightSelectorsRequest { }): GetInsightSelectorsResponse

    /**
     * Gets event data results of a query. You must specify the `QueryID` value returned by the `StartQuery` operation.
     */
    public suspend fun getQueryResults(input: GetQueryResultsRequest): GetQueryResultsResponse

    /**
     * Retrieves the JSON text of the resource-based policy document attached to the CloudTrail event data store, dashboard, or channel.
     */
    public suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse

    /**
     * Returns settings information for a specified trail.
     */
    public suspend fun getTrail(input: GetTrailRequest): GetTrailResponse

    /**
     * Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns trail status from a single Region. To return trail status from all Regions, you must call the operation on each Region.
     */
    public suspend fun getTrailStatus(input: GetTrailStatusRequest): GetTrailStatusResponse

    /**
     * Lists the channels in the current account, and their source names.
     */
    public suspend fun listChannels(input: ListChannelsRequest = ListChannelsRequest { }): ListChannelsResponse

    /**
     * Returns information about all dashboards in the account, in the current Region.
     */
    public suspend fun listDashboards(input: ListDashboardsRequest = ListDashboardsRequest { }): ListDashboardsResponse

    /**
     * Returns information about all event data stores in the account, in the current Region.
     */
    public suspend fun listEventDataStores(input: ListEventDataStoresRequest = ListEventDataStoresRequest { }): ListEventDataStoresResponse

    /**
     * Returns a list of failures for the specified import.
     */
    public suspend fun listImportFailures(input: ListImportFailuresRequest): ListImportFailuresResponse

    /**
     * Returns information on all imports, or a select set of imports by `ImportStatus` or `Destination`.
     */
    public suspend fun listImports(input: ListImportsRequest = ListImportsRequest { }): ListImportsResponse

    /**
     * Returns Insights metrics data for trails that have enabled Insights. The request must include the `EventSource`, `EventName`, and `InsightType` parameters.
     *
     * If the `InsightType` is set to `ApiErrorRateInsight`, the request must also include the `ErrorCode` parameter.
     *
     * The following are the available time periods for `ListInsightsMetricData`. Each cutoff is inclusive.
     * + Data points with a period of 60 seconds (1-minute) are available for 15 days.
     * + Data points with a period of 300 seconds (5-minute) are available for 63 days.
     * + Data points with a period of 3600 seconds (1 hour) are available for 90 days.
     *
     * Access to the `ListInsightsMetricData` API operation is linked to the `cloudtrail:LookupEvents` action. To use this operation, you must have permissions to perform the `cloudtrail:LookupEvents` action.
     */
    public suspend fun listInsightsMetricData(input: ListInsightsMetricDataRequest): ListInsightsMetricDataResponse

    /**
     * Returns all public keys whose private keys were used to sign the digest files within the specified time range. The public key is needed to validate digest files that were signed with its corresponding private key.
     *
     * CloudTrail uses different private and public key pairs per Region. Each digest file is signed with a private key unique to its Region. When you validate a digest file from a specific Region, you must look in the same Region for its corresponding public key.
     */
    public suspend fun listPublicKeys(input: ListPublicKeysRequest = ListPublicKeysRequest { }): ListPublicKeysResponse

    /**
     * Returns a list of queries and query statuses for the past seven days. You must specify an ARN value for `EventDataStore`. Optionally, to shorten the list of results, you can specify a time range, formatted as timestamps, by adding `StartTime` and `EndTime` parameters, and a `QueryStatus` value. Valid values for `QueryStatus` include `QUEUED`, `RUNNING`, `FINISHED`, `FAILED`, `TIMED_OUT`, or `CANCELLED`.
     */
    public suspend fun listQueries(input: ListQueriesRequest): ListQueriesResponse

    /**
     * Lists the tags for the specified trails, event data stores, dashboards, or channels in the current Region.
     */
    public suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Lists trails that are in the current account.
     */
    public suspend fun listTrails(input: ListTrailsRequest = ListTrailsRequest { }): ListTrailsResponse

    /**
     * Looks up [management events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events) or [CloudTrail Insights events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events) that are captured by CloudTrail. You can look up events that occurred in a Region within the last 90 days.
     *
     * `LookupEvents` returns recent Insights events for trails that enable Insights. To view Insights events for an event data store, you can run queries on your Insights event data store, and you can also view the Lake dashboard for Insights.
     *
     * Lookup supports the following attributes for management events:
     * + Amazon Web Services access key
     * + Event ID
     * + Event name
     * + Event source
     * + Read only
     * + Resource name
     * + Resource type
     * + User name
     *
     * Lookup supports the following attributes for Insights events:
     * + Event ID
     * + Event name
     * + Event source
     *
     * All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The response includes a token that you can use to get the next page of results.
     *
     * The rate of lookup requests is limited to two per second, per account, per Region. If this limit is exceeded, a throttling error occurs.
     */
    public suspend fun lookupEvents(input: LookupEventsRequest = LookupEventsRequest { }): LookupEventsResponse

    /**
     * Updates the event configuration settings for the specified event data store. You can update the maximum event size and context key selectors.
     */
    public suspend fun putEventConfiguration(input: PutEventConfigurationRequest): PutEventConfigurationResponse

    /**
     * Configures event selectors (also referred to as *basic event selectors*) or advanced event selectors for your trail. You can use either `AdvancedEventSelectors` or `EventSelectors`, but not both. If you apply `AdvancedEventSelectors` to a trail, any existing `EventSelectors` are overwritten.
     *
     * You can use `AdvancedEventSelectors` to log management events, data events for all resource types, and network activity events.
     *
     * You can use `EventSelectors` to log management events and data events for the following resource types:
     * + `AWS::DynamoDB::Table`
     * + `AWS::Lambda::Function`
     * + `AWS::S3::Object`
     *
     * You can't use `EventSelectors` to log network activity events.
     *
     * If you want your trail to log Insights events, be sure the event selector or advanced event selector enables logging of the Insights event types you want configured for your trail. For more information about logging Insights events, see [Working with CloudTrail Insights](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html) in the *CloudTrail User Guide*. By default, trails created without specific event selectors are configured to log all read and write management events, and no data events or network activity events.
     *
     * When an event occurs in your account, CloudTrail evaluates the event selectors or advanced event selectors in all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
     *
     * Example
     * + You create an event selector for a trail and specify that you want to log write-only events.
     * + The EC2 `GetConsoleOutput` and `RunInstances` API operations occur in your account.
     * + CloudTrail evaluates whether the events match your event selectors.
     * + The `RunInstances` is a write-only event and it matches your event selector. The trail logs the event.
     * + The `GetConsoleOutput` is a read-only event that doesn't match your event selector. The trail doesn't log the event.
     *
     * The `PutEventSelectors` operation must be called from the Region in which the trail was created; otherwise, an `InvalidHomeRegionException` exception is thrown.
     *
     * You can configure up to five event selectors for each trail.
     *
     * You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. For more information, see [Logging management events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html), [Logging data events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html), [Logging network activity events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html), and [Quotas in CloudTrail](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html) in the *CloudTrail User Guide*.
     */
    public suspend fun putEventSelectors(input: PutEventSelectorsRequest): PutEventSelectorsResponse

    /**
     * Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an existing trail or event data store. You also use `PutInsightSelectors` to turn off Insights event logging, by passing an empty list of Insights types. The valid Insights event types are `ApiErrorRateInsight` and `ApiCallRateInsight`.
     *
     * To enable Insights on an event data store, you must specify the ARNs (or ID suffix of the ARNs) for the source event data store (`EventDataStore`) and the destination event data store (`InsightsDestination`). The source event data store logs management events and enables Insights. The destination event data store logs Insights events based upon the management event activity of the source event data store. The source and destination event data stores must belong to the same Amazon Web Services account.
     *
     * To log Insights events for a trail, you must specify the name (`TrailName`) of the CloudTrail trail for which you want to change or add Insights selectors.
     *
     * To log CloudTrail Insights events on API call volume, the trail or event data store must log `write` management events. To log CloudTrail Insights events on API error rate, the trail or event data store must log `read` or `write` management events. You can call `GetEventSelectors` on a trail to check whether the trail logs management events. You can call `GetEventDataStore` on an event data store to check whether the event data store logs management events.
     *
     * For more information, see [Working with CloudTrail Insights](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
     */
    public suspend fun putInsightSelectors(input: PutInsightSelectorsRequest): PutInsightSelectorsResponse

    /**
     * Attaches a resource-based permission policy to a CloudTrail event data store, dashboard, or channel. For more information about resource-based policies, see [CloudTrail resource-based policy examples](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html) in the *CloudTrail User Guide*.
     */
    public suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Registers an organization’s member account as the CloudTrail [delegated administrator](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-delegated-administrator.html).
     */
    public suspend fun registerOrganizationDelegatedAdmin(input: RegisterOrganizationDelegatedAdminRequest): RegisterOrganizationDelegatedAdminResponse

    /**
     * Removes the specified tags from a trail, event data store, dashboard, or channel.
     */
    public suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse

    /**
     * Restores a deleted event data store specified by `EventDataStore`, which accepts an event data store ARN. You can only restore a deleted event data store within the seven-day wait period after deletion. Restoring an event data store can take several minutes, depending on the size of the event data store.
     */
    public suspend fun restoreEventDataStore(input: RestoreEventDataStoreRequest): RestoreEventDataStoreResponse

    /**
     * Searches sample queries and returns a list of sample queries that are sorted by relevance. To search for sample queries, provide a natural language `SearchPhrase` in English.
     */
    public suspend fun searchSampleQueries(input: SearchSampleQueriesRequest): SearchSampleQueriesResponse

    /**
     * Starts a refresh of the specified dashboard.
     *
     *  Each time a dashboard is refreshed, CloudTrail runs queries to populate the dashboard's widgets. CloudTrail must be granted permissions to run the `StartQuery` operation on your behalf. To provide permissions, run the `PutResourcePolicy` operation to attach a resource-based policy to each event data store. For more information, see [Example: Allow CloudTrail to run queries to populate a dashboard](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard) in the *CloudTrail User Guide*.
     */
    public suspend fun startDashboardRefresh(input: StartDashboardRefreshRequest): StartDashboardRefreshResponse

    /**
     * Starts the ingestion of live events on an event data store specified as either an ARN or the ID portion of the ARN. To start ingestion, the event data store `Status` must be `STOPPED_INGESTION` and the `eventCategory` must be `Management`, `Data`, `NetworkActivity`, or `ConfigurationItem`.
     */
    public suspend fun startEventDataStoreIngestion(input: StartEventDataStoreIngestionRequest): StartEventDataStoreIngestionResponse

    /**
     * Starts an import of logged trail events from a source S3 bucket to a destination event data store. By default, CloudTrail only imports events contained in the S3 bucket's `CloudTrail` prefix and the prefixes inside the `CloudTrail` prefix, and does not check prefixes for other Amazon Web Services services. If you want to import CloudTrail events contained in another prefix, you must include the prefix in the `S3LocationUri`. For more considerations about importing trail events, see [Considerations for copying trail events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-copy-trail-to-lake.html#cloudtrail-trail-copy-considerations) in the *CloudTrail User Guide*.
     *
     *  When you start a new import, the `Destinations` and `ImportSource` parameters are required. Before starting a new import, disable any access control lists (ACLs) attached to the source S3 bucket. For more information about disabling ACLs, see [Controlling ownership of objects and disabling ACLs for your bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html).
     *
     *  When you retry an import, the `ImportID` parameter is required.
     *
     *  If the destination event data store is for an organization, you must use the management account to import trail events. You cannot use the delegated administrator account for the organization.
     */
    public suspend fun startImport(input: StartImportRequest = StartImportRequest { }): StartImportResponse

    /**
     * Starts the recording of Amazon Web Services API calls and log file delivery for a trail. For a trail that is enabled in all Regions, this operation must be called from the Region in which the trail was created. This operation cannot be called on the shadow trails (replicated trails in other Regions) of a trail that is enabled in all Regions.
     */
    public suspend fun startLogging(input: StartLoggingRequest): StartLoggingResponse

    /**
     * Starts a CloudTrail Lake query. Use the `QueryStatement` parameter to provide your SQL query, enclosed in single quotation marks. Use the optional `DeliveryS3Uri` parameter to deliver the query results to an S3 bucket.
     *
     * `StartQuery` requires you specify either the `QueryStatement` parameter, or a `QueryAlias` and any `QueryParameters`. In the current release, the `QueryAlias` and `QueryParameters` parameters are used only for the queries that populate the CloudTrail Lake dashboards.
     */
    public suspend fun startQuery(input: StartQueryRequest = StartQueryRequest { }): StartQueryResponse

    /**
     * Stops the ingestion of live events on an event data store specified as either an ARN or the ID portion of the ARN. To stop ingestion, the event data store `Status` must be `ENABLED` and the `eventCategory` must be `Management`, `Data`, `NetworkActivity`, or `ConfigurationItem`.
     */
    public suspend fun stopEventDataStoreIngestion(input: StopEventDataStoreIngestionRequest): StopEventDataStoreIngestionResponse

    /**
     * Stops a specified import.
     */
    public suspend fun stopImport(input: StopImportRequest): StopImportResponse

    /**
     * Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail. Under most circumstances, there is no need to use this action. You can update a trail without stopping it first. This action is the only way to stop recording. For a trail enabled in all Regions, this operation must be called from the Region in which the trail was created, or an `InvalidHomeRegionException` will occur. This operation cannot be called on the shadow trails (replicated trails in other Regions) of a trail enabled in all Regions.
     */
    public suspend fun stopLogging(input: StopLoggingRequest): StopLoggingResponse

    /**
     * Updates a channel specified by a required channel ARN or UUID.
     */
    public suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse

    /**
     * Updates the specified dashboard.
     *
     *  To set a refresh schedule, CloudTrail must be granted permissions to run the `StartDashboardRefresh` operation to refresh the dashboard on your behalf. To provide permissions, run the `PutResourcePolicy` operation to attach a resource-based policy to the dashboard. For more information, see [ Resource-based policy example for a dashboard](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-dashboards) in the *CloudTrail User Guide*.
     *
     *  CloudTrail runs queries to populate the dashboard's widgets during a manual or scheduled refresh. CloudTrail must be granted permissions to run the `StartQuery` operation on your behalf. To provide permissions, run the `PutResourcePolicy` operation to attach a resource-based policy to each event data store. For more information, see [Example: Allow CloudTrail to run queries to populate a dashboard](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard) in the *CloudTrail User Guide*.
     */
    public suspend fun updateDashboard(input: UpdateDashboardRequest): UpdateDashboardResponse

    /**
     * Updates an event data store. The required `EventDataStore` value is an ARN or the ID portion of the ARN. Other parameters are optional, but at least one optional parameter must be specified, or CloudTrail throws an error. `RetentionPeriod` is in days, and valid values are integers between 7 and 3653 if the `BillingMode` is set to `EXTENDABLE_RETENTION_PRICING`, or between 7 and 2557 if `BillingMode` is set to `FIXED_RETENTION_PRICING`. By default, `TerminationProtection` is enabled.
     *
     * For event data stores for CloudTrail events, `AdvancedEventSelectors` includes or excludes management, data, or network activity events in your event data store. For more information about `AdvancedEventSelectors`, see [AdvancedEventSelectors](https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html).
     *
     *  For event data stores for CloudTrail Insights events, Config configuration items, Audit Manager evidence, or non-Amazon Web Services events, `AdvancedEventSelectors` includes events of that type in your event data store.
     */
    public suspend fun updateEventDataStore(input: UpdateEventDataStoreRequest): UpdateEventDataStoreResponse

    /**
     * Updates trail settings that control what events you are logging, and how to handle log files. Changes to a trail do not require stopping the CloudTrail service. Use this action to designate an existing bucket for log delivery. If the existing bucket has previously been a target for CloudTrail log files, an IAM policy exists for the bucket. `UpdateTrail` must be called from the Region in which the trail was created; otherwise, an `InvalidHomeRegionException` is thrown.
     */
    public suspend fun updateTrail(input: UpdateTrailRequest): UpdateTrailResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CloudTrailClient.withConfig(block: CloudTrailClient.Config.Builder.() -> Unit): CloudTrailClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCloudTrailClient(newConfig)
}

/**
 * Adds one or more tags to a trail, event data store, dashboard, or channel, up to a limit of 50. Overwrites an existing tag's value when a new value is specified for an existing tag key. Tag key names must be unique; you cannot have two keys with the same name but different values. If you specify a key without a value, the tag will be created with the specified key and a value of null. You can tag a trail or event data store that applies to all Amazon Web Services Regions only from the Region in which the trail or event data store was created (also known as its home Region).
 */
public suspend inline fun CloudTrailClient.addTags(crossinline block: AddTagsRequest.Builder.() -> Unit): AddTagsResponse = addTags(AddTagsRequest.Builder().apply(block).build())

/**
 * Cancels a query if the query is not in a terminated state, such as `CANCELLED`, `FAILED`, `TIMED_OUT`, or `FINISHED`. You must specify an ARN value for `EventDataStore`. The ID of the query that you want to cancel is also required. When you run `CancelQuery`, the query status might show as `CANCELLED` even if the operation is not yet finished.
 */
public suspend inline fun CloudTrailClient.cancelQuery(crossinline block: CancelQueryRequest.Builder.() -> Unit): CancelQueryResponse = cancelQuery(CancelQueryRequest.Builder().apply(block).build())

/**
 * Creates a channel for CloudTrail to ingest events from a partner or external source. After you create a channel, a CloudTrail Lake event data store can log events from the partner or source that you specify.
 */
public suspend inline fun CloudTrailClient.createChannel(crossinline block: CreateChannelRequest.Builder.() -> Unit): CreateChannelResponse = createChannel(CreateChannelRequest.Builder().apply(block).build())

/**
 * Creates a custom dashboard or the Highlights dashboard.
 * + **Custom dashboards** - Custom dashboards allow you to query events in any event data store type. You can add up to 10 widgets to a custom dashboard. You can manually refresh a custom dashboard, or you can set a refresh schedule.
 * + **Highlights dashboard** - You can create the Highlights dashboard to see a summary of key user activities and API usage across all your event data stores. CloudTrail Lake manages the Highlights dashboard and refreshes the dashboard every 6 hours. To create the Highlights dashboard, you must set and enable a refresh schedule.
 *
 *  CloudTrail runs queries to populate the dashboard's widgets during a manual or scheduled refresh. CloudTrail must be granted permissions to run the `StartQuery` operation on your behalf. To provide permissions, run the `PutResourcePolicy` operation to attach a resource-based policy to each event data store. For more information, see [Example: Allow CloudTrail to run queries to populate a dashboard](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard) in the *CloudTrail User Guide*.
 *
 *  To set a refresh schedule, CloudTrail must be granted permissions to run the `StartDashboardRefresh` operation to refresh the dashboard on your behalf. To provide permissions, run the `PutResourcePolicy` operation to attach a resource-based policy to the dashboard. For more information, see [ Resource-based policy example for a dashboard](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-dashboards) in the *CloudTrail User Guide*.
 *
 * For more information about dashboards, see [CloudTrail Lake dashboards](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-dashboard.html) in the *CloudTrail User Guide*.
 */
public suspend inline fun CloudTrailClient.createDashboard(crossinline block: CreateDashboardRequest.Builder.() -> Unit): CreateDashboardResponse = createDashboard(CreateDashboardRequest.Builder().apply(block).build())

/**
 * Creates a new event data store.
 */
public suspend inline fun CloudTrailClient.createEventDataStore(crossinline block: CreateEventDataStoreRequest.Builder.() -> Unit): CreateEventDataStoreResponse = createEventDataStore(CreateEventDataStoreRequest.Builder().apply(block).build())

/**
 * Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
 */
public suspend inline fun CloudTrailClient.createTrail(crossinline block: CreateTrailRequest.Builder.() -> Unit): CreateTrailResponse = createTrail(CreateTrailRequest.Builder().apply(block).build())

/**
 * Deletes a channel.
 */
public suspend inline fun CloudTrailClient.deleteChannel(crossinline block: DeleteChannelRequest.Builder.() -> Unit): DeleteChannelResponse = deleteChannel(DeleteChannelRequest.Builder().apply(block).build())

/**
 * Deletes the specified dashboard. You cannot delete a dashboard that has termination protection enabled.
 */
public suspend inline fun CloudTrailClient.deleteDashboard(crossinline block: DeleteDashboardRequest.Builder.() -> Unit): DeleteDashboardResponse = deleteDashboard(DeleteDashboardRequest.Builder().apply(block).build())

/**
 * Disables the event data store specified by `EventDataStore`, which accepts an event data store ARN. After you run `DeleteEventDataStore`, the event data store enters a `PENDING_DELETION` state, and is automatically deleted after a wait period of seven days. `TerminationProtectionEnabled` must be set to `False` on the event data store and the `FederationStatus` must be `DISABLED`. You cannot delete an event data store if `TerminationProtectionEnabled` is `True` or the `FederationStatus` is `ENABLED`.
 *
 * After you run `DeleteEventDataStore` on an event data store, you cannot run `ListQueries`, `DescribeQuery`, or `GetQueryResults` on queries that are using an event data store in a `PENDING_DELETION` state. An event data store in the `PENDING_DELETION` state does not incur costs.
 */
public suspend inline fun CloudTrailClient.deleteEventDataStore(crossinline block: DeleteEventDataStoreRequest.Builder.() -> Unit): DeleteEventDataStoreResponse = deleteEventDataStore(DeleteEventDataStoreRequest.Builder().apply(block).build())

/**
 * Deletes the resource-based policy attached to the CloudTrail event data store, dashboard, or channel.
 */
public suspend inline fun CloudTrailClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Deletes a trail. This operation must be called from the Region in which the trail was created. `DeleteTrail` cannot be called on the shadow trails (replicated trails in other Regions) of a trail that is enabled in all Regions.
 */
public suspend inline fun CloudTrailClient.deleteTrail(crossinline block: DeleteTrailRequest.Builder.() -> Unit): DeleteTrailResponse = deleteTrail(DeleteTrailRequest.Builder().apply(block).build())

/**
 * Removes CloudTrail delegated administrator permissions from a member account in an organization.
 */
public suspend inline fun CloudTrailClient.deregisterOrganizationDelegatedAdmin(crossinline block: DeregisterOrganizationDelegatedAdminRequest.Builder.() -> Unit): DeregisterOrganizationDelegatedAdminResponse = deregisterOrganizationDelegatedAdmin(DeregisterOrganizationDelegatedAdminRequest.Builder().apply(block).build())

/**
 * Returns metadata about a query, including query run time in milliseconds, number of events scanned and matched, and query status. If the query results were delivered to an S3 bucket, the response also provides the S3 URI and the delivery status.
 *
 * You must specify either `QueryId` or `QueryAlias`. Specifying the `QueryAlias` parameter returns information about the last query run for the alias. You can provide `RefreshId` along with `QueryAlias` to view the query results of a dashboard query for the specified `RefreshId`.
 */
public suspend inline fun CloudTrailClient.describeQuery(crossinline block: DescribeQueryRequest.Builder.() -> Unit): DescribeQueryResponse = describeQuery(DescribeQueryRequest.Builder().apply(block).build())

/**
 * Retrieves settings for one or more trails associated with the current Region for your account.
 */
public suspend inline fun CloudTrailClient.describeTrails(crossinline block: DescribeTrailsRequest.Builder.() -> Unit): DescribeTrailsResponse = describeTrails(DescribeTrailsRequest.Builder().apply(block).build())

/**
 * Disables Lake query federation on the specified event data store. When you disable federation, CloudTrail disables the integration with Glue, Lake Formation, and Amazon Athena. After disabling Lake query federation, you can no longer query your event data in Amazon Athena.
 *
 * No CloudTrail Lake data is deleted when you disable federation and you can continue to run queries in CloudTrail Lake.
 */
public suspend inline fun CloudTrailClient.disableFederation(crossinline block: DisableFederationRequest.Builder.() -> Unit): DisableFederationResponse = disableFederation(DisableFederationRequest.Builder().apply(block).build())

/**
 * Enables Lake query federation on the specified event data store. Federating an event data store lets you view the metadata associated with the event data store in the Glue [Data Catalog](https://docs.aws.amazon.com/glue/latest/dg/components-overview.html#data-catalog-intro) and run SQL queries against your event data using Amazon Athena. The table metadata stored in the Glue Data Catalog lets the Athena query engine know how to find, read, and process the data that you want to query.
 *
 * When you enable Lake query federation, CloudTrail creates a managed database named `aws:cloudtrail` (if the database doesn't already exist) and a managed federated table in the Glue Data Catalog. The event data store ID is used for the table name. CloudTrail registers the role ARN and event data store in [Lake Formation](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation-lake-formation.html), the service responsible for allowing fine-grained access control of the federated resources in the Glue Data Catalog.
 *
 * For more information about Lake query federation, see [Federate an event data store](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html).
 */
public suspend inline fun CloudTrailClient.enableFederation(crossinline block: EnableFederationRequest.Builder.() -> Unit): EnableFederationResponse = enableFederation(EnableFederationRequest.Builder().apply(block).build())

/**
 * Generates a query from a natural language prompt. This operation uses generative artificial intelligence (generative AI) to produce a ready-to-use SQL query from the prompt.
 *
 * The prompt can be a question or a statement about the event data in your event data store. For example, you can enter prompts like "What are my top errors in the past month?" and “Give me a list of users that used SNS.”
 *
 * The prompt must be in English. For information about limitations, permissions, and supported Regions, see [Create CloudTrail Lake queries from natural language prompts](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-query-generator.html) in the *CloudTrail * user guide.
 *
 * Do not include any personally identifying, confidential, or sensitive information in your prompts.
 *
 * This feature uses generative AI large language models (LLMs); we recommend double-checking the LLM response.
 */
public suspend inline fun CloudTrailClient.generateQuery(crossinline block: GenerateQueryRequest.Builder.() -> Unit): GenerateQueryResponse = generateQuery(GenerateQueryRequest.Builder().apply(block).build())

/**
 * Returns information about a specific channel.
 */
public suspend inline fun CloudTrailClient.getChannel(crossinline block: GetChannelRequest.Builder.() -> Unit): GetChannelResponse = getChannel(GetChannelRequest.Builder().apply(block).build())

/**
 * Returns the specified dashboard.
 */
public suspend inline fun CloudTrailClient.getDashboard(crossinline block: GetDashboardRequest.Builder.() -> Unit): GetDashboardResponse = getDashboard(GetDashboardRequest.Builder().apply(block).build())

/**
 * Retrieves the current event configuration settings for the specified event data store, including details about maximum event size and context key selectors configured for the event data store.
 */
public suspend inline fun CloudTrailClient.getEventConfiguration(crossinline block: GetEventConfigurationRequest.Builder.() -> Unit): GetEventConfigurationResponse = getEventConfiguration(GetEventConfigurationRequest.Builder().apply(block).build())

/**
 * Returns information about an event data store specified as either an ARN or the ID portion of the ARN.
 */
public suspend inline fun CloudTrailClient.getEventDataStore(crossinline block: GetEventDataStoreRequest.Builder.() -> Unit): GetEventDataStoreResponse = getEventDataStore(GetEventDataStoreRequest.Builder().apply(block).build())

/**
 * Describes the settings for the event selectors that you configured for your trail. The information returned for your event selectors includes the following:
 * + If your event selector includes read-only events, write-only events, or all events. This applies to management events, data events, and network activity events.
 * + If your event selector includes management events.
 * + If your event selector includes network activity events, the event sources for which you are logging network activity events.
 * + If your event selector includes data events, the resources on which you are logging data events.
 *
 * For more information about logging management, data, and network activity events, see the following topics in the *CloudTrail User Guide*:
 * + [Logging management events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html)
 * + [Logging data events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html)
 * + [Logging network activity events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html)
 */
public suspend inline fun CloudTrailClient.getEventSelectors(crossinline block: GetEventSelectorsRequest.Builder.() -> Unit): GetEventSelectorsResponse = getEventSelectors(GetEventSelectorsRequest.Builder().apply(block).build())

/**
 * Returns information about a specific import.
 */
public suspend inline fun CloudTrailClient.getImport(crossinline block: GetImportRequest.Builder.() -> Unit): GetImportResponse = getImport(GetImportRequest.Builder().apply(block).build())

/**
 * Describes the settings for the Insights event selectors that you configured for your trail or event data store. `GetInsightSelectors` shows if CloudTrail Insights event logging is enabled on the trail or event data store, and if it is, which Insights types are enabled. If you run `GetInsightSelectors` on a trail or event data store that does not have Insights events enabled, the operation throws the exception `InsightNotEnabledException`
 *
 * Specify either the `EventDataStore` parameter to get Insights event selectors for an event data store, or the `TrailName` parameter to the get Insights event selectors for a trail. You cannot specify these parameters together.
 *
 * For more information, see [Working with CloudTrail Insights](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
 */
public suspend inline fun CloudTrailClient.getInsightSelectors(crossinline block: GetInsightSelectorsRequest.Builder.() -> Unit): GetInsightSelectorsResponse = getInsightSelectors(GetInsightSelectorsRequest.Builder().apply(block).build())

/**
 * Gets event data results of a query. You must specify the `QueryID` value returned by the `StartQuery` operation.
 */
public suspend inline fun CloudTrailClient.getQueryResults(crossinline block: GetQueryResultsRequest.Builder.() -> Unit): GetQueryResultsResponse = getQueryResults(GetQueryResultsRequest.Builder().apply(block).build())

/**
 * Retrieves the JSON text of the resource-based policy document attached to the CloudTrail event data store, dashboard, or channel.
 */
public suspend inline fun CloudTrailClient.getResourcePolicy(crossinline block: GetResourcePolicyRequest.Builder.() -> Unit): GetResourcePolicyResponse = getResourcePolicy(GetResourcePolicyRequest.Builder().apply(block).build())

/**
 * Returns settings information for a specified trail.
 */
public suspend inline fun CloudTrailClient.getTrail(crossinline block: GetTrailRequest.Builder.() -> Unit): GetTrailResponse = getTrail(GetTrailRequest.Builder().apply(block).build())

/**
 * Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns trail status from a single Region. To return trail status from all Regions, you must call the operation on each Region.
 */
public suspend inline fun CloudTrailClient.getTrailStatus(crossinline block: GetTrailStatusRequest.Builder.() -> Unit): GetTrailStatusResponse = getTrailStatus(GetTrailStatusRequest.Builder().apply(block).build())

/**
 * Lists the channels in the current account, and their source names.
 */
public suspend inline fun CloudTrailClient.listChannels(crossinline block: ListChannelsRequest.Builder.() -> Unit): ListChannelsResponse = listChannels(ListChannelsRequest.Builder().apply(block).build())

/**
 * Returns information about all dashboards in the account, in the current Region.
 */
public suspend inline fun CloudTrailClient.listDashboards(crossinline block: ListDashboardsRequest.Builder.() -> Unit): ListDashboardsResponse = listDashboards(ListDashboardsRequest.Builder().apply(block).build())

/**
 * Returns information about all event data stores in the account, in the current Region.
 */
public suspend inline fun CloudTrailClient.listEventDataStores(crossinline block: ListEventDataStoresRequest.Builder.() -> Unit): ListEventDataStoresResponse = listEventDataStores(ListEventDataStoresRequest.Builder().apply(block).build())

/**
 * Returns a list of failures for the specified import.
 */
public suspend inline fun CloudTrailClient.listImportFailures(crossinline block: ListImportFailuresRequest.Builder.() -> Unit): ListImportFailuresResponse = listImportFailures(ListImportFailuresRequest.Builder().apply(block).build())

/**
 * Returns information on all imports, or a select set of imports by `ImportStatus` or `Destination`.
 */
public suspend inline fun CloudTrailClient.listImports(crossinline block: ListImportsRequest.Builder.() -> Unit): ListImportsResponse = listImports(ListImportsRequest.Builder().apply(block).build())

/**
 * Returns Insights metrics data for trails that have enabled Insights. The request must include the `EventSource`, `EventName`, and `InsightType` parameters.
 *
 * If the `InsightType` is set to `ApiErrorRateInsight`, the request must also include the `ErrorCode` parameter.
 *
 * The following are the available time periods for `ListInsightsMetricData`. Each cutoff is inclusive.
 * + Data points with a period of 60 seconds (1-minute) are available for 15 days.
 * + Data points with a period of 300 seconds (5-minute) are available for 63 days.
 * + Data points with a period of 3600 seconds (1 hour) are available for 90 days.
 *
 * Access to the `ListInsightsMetricData` API operation is linked to the `cloudtrail:LookupEvents` action. To use this operation, you must have permissions to perform the `cloudtrail:LookupEvents` action.
 */
public suspend inline fun CloudTrailClient.listInsightsMetricData(crossinline block: ListInsightsMetricDataRequest.Builder.() -> Unit): ListInsightsMetricDataResponse = listInsightsMetricData(ListInsightsMetricDataRequest.Builder().apply(block).build())

/**
 * Returns all public keys whose private keys were used to sign the digest files within the specified time range. The public key is needed to validate digest files that were signed with its corresponding private key.
 *
 * CloudTrail uses different private and public key pairs per Region. Each digest file is signed with a private key unique to its Region. When you validate a digest file from a specific Region, you must look in the same Region for its corresponding public key.
 */
public suspend inline fun CloudTrailClient.listPublicKeys(crossinline block: ListPublicKeysRequest.Builder.() -> Unit): ListPublicKeysResponse = listPublicKeys(ListPublicKeysRequest.Builder().apply(block).build())

/**
 * Returns a list of queries and query statuses for the past seven days. You must specify an ARN value for `EventDataStore`. Optionally, to shorten the list of results, you can specify a time range, formatted as timestamps, by adding `StartTime` and `EndTime` parameters, and a `QueryStatus` value. Valid values for `QueryStatus` include `QUEUED`, `RUNNING`, `FINISHED`, `FAILED`, `TIMED_OUT`, or `CANCELLED`.
 */
public suspend inline fun CloudTrailClient.listQueries(crossinline block: ListQueriesRequest.Builder.() -> Unit): ListQueriesResponse = listQueries(ListQueriesRequest.Builder().apply(block).build())

/**
 * Lists the tags for the specified trails, event data stores, dashboards, or channels in the current Region.
 */
public suspend inline fun CloudTrailClient.listTags(crossinline block: ListTagsRequest.Builder.() -> Unit): ListTagsResponse = listTags(ListTagsRequest.Builder().apply(block).build())

/**
 * Lists trails that are in the current account.
 */
public suspend inline fun CloudTrailClient.listTrails(crossinline block: ListTrailsRequest.Builder.() -> Unit): ListTrailsResponse = listTrails(ListTrailsRequest.Builder().apply(block).build())

/**
 * Looks up [management events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events) or [CloudTrail Insights events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events) that are captured by CloudTrail. You can look up events that occurred in a Region within the last 90 days.
 *
 * `LookupEvents` returns recent Insights events for trails that enable Insights. To view Insights events for an event data store, you can run queries on your Insights event data store, and you can also view the Lake dashboard for Insights.
 *
 * Lookup supports the following attributes for management events:
 * + Amazon Web Services access key
 * + Event ID
 * + Event name
 * + Event source
 * + Read only
 * + Resource name
 * + Resource type
 * + User name
 *
 * Lookup supports the following attributes for Insights events:
 * + Event ID
 * + Event name
 * + Event source
 *
 * All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The response includes a token that you can use to get the next page of results.
 *
 * The rate of lookup requests is limited to two per second, per account, per Region. If this limit is exceeded, a throttling error occurs.
 */
public suspend inline fun CloudTrailClient.lookupEvents(crossinline block: LookupEventsRequest.Builder.() -> Unit): LookupEventsResponse = lookupEvents(LookupEventsRequest.Builder().apply(block).build())

/**
 * Updates the event configuration settings for the specified event data store. You can update the maximum event size and context key selectors.
 */
public suspend inline fun CloudTrailClient.putEventConfiguration(crossinline block: PutEventConfigurationRequest.Builder.() -> Unit): PutEventConfigurationResponse = putEventConfiguration(PutEventConfigurationRequest.Builder().apply(block).build())

/**
 * Configures event selectors (also referred to as *basic event selectors*) or advanced event selectors for your trail. You can use either `AdvancedEventSelectors` or `EventSelectors`, but not both. If you apply `AdvancedEventSelectors` to a trail, any existing `EventSelectors` are overwritten.
 *
 * You can use `AdvancedEventSelectors` to log management events, data events for all resource types, and network activity events.
 *
 * You can use `EventSelectors` to log management events and data events for the following resource types:
 * + `AWS::DynamoDB::Table`
 * + `AWS::Lambda::Function`
 * + `AWS::S3::Object`
 *
 * You can't use `EventSelectors` to log network activity events.
 *
 * If you want your trail to log Insights events, be sure the event selector or advanced event selector enables logging of the Insights event types you want configured for your trail. For more information about logging Insights events, see [Working with CloudTrail Insights](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html) in the *CloudTrail User Guide*. By default, trails created without specific event selectors are configured to log all read and write management events, and no data events or network activity events.
 *
 * When an event occurs in your account, CloudTrail evaluates the event selectors or advanced event selectors in all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
 *
 * Example
 * + You create an event selector for a trail and specify that you want to log write-only events.
 * + The EC2 `GetConsoleOutput` and `RunInstances` API operations occur in your account.
 * + CloudTrail evaluates whether the events match your event selectors.
 * + The `RunInstances` is a write-only event and it matches your event selector. The trail logs the event.
 * + The `GetConsoleOutput` is a read-only event that doesn't match your event selector. The trail doesn't log the event.
 *
 * The `PutEventSelectors` operation must be called from the Region in which the trail was created; otherwise, an `InvalidHomeRegionException` exception is thrown.
 *
 * You can configure up to five event selectors for each trail.
 *
 * You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. For more information, see [Logging management events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html), [Logging data events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html), [Logging network activity events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html), and [Quotas in CloudTrail](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html) in the *CloudTrail User Guide*.
 */
public suspend inline fun CloudTrailClient.putEventSelectors(crossinline block: PutEventSelectorsRequest.Builder.() -> Unit): PutEventSelectorsResponse = putEventSelectors(PutEventSelectorsRequest.Builder().apply(block).build())

/**
 * Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an existing trail or event data store. You also use `PutInsightSelectors` to turn off Insights event logging, by passing an empty list of Insights types. The valid Insights event types are `ApiErrorRateInsight` and `ApiCallRateInsight`.
 *
 * To enable Insights on an event data store, you must specify the ARNs (or ID suffix of the ARNs) for the source event data store (`EventDataStore`) and the destination event data store (`InsightsDestination`). The source event data store logs management events and enables Insights. The destination event data store logs Insights events based upon the management event activity of the source event data store. The source and destination event data stores must belong to the same Amazon Web Services account.
 *
 * To log Insights events for a trail, you must specify the name (`TrailName`) of the CloudTrail trail for which you want to change or add Insights selectors.
 *
 * To log CloudTrail Insights events on API call volume, the trail or event data store must log `write` management events. To log CloudTrail Insights events on API error rate, the trail or event data store must log `read` or `write` management events. You can call `GetEventSelectors` on a trail to check whether the trail logs management events. You can call `GetEventDataStore` on an event data store to check whether the event data store logs management events.
 *
 * For more information, see [Working with CloudTrail Insights](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
 */
public suspend inline fun CloudTrailClient.putInsightSelectors(crossinline block: PutInsightSelectorsRequest.Builder.() -> Unit): PutInsightSelectorsResponse = putInsightSelectors(PutInsightSelectorsRequest.Builder().apply(block).build())

/**
 * Attaches a resource-based permission policy to a CloudTrail event data store, dashboard, or channel. For more information about resource-based policies, see [CloudTrail resource-based policy examples](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html) in the *CloudTrail User Guide*.
 */
public suspend inline fun CloudTrailClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit): PutResourcePolicyResponse = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Registers an organization’s member account as the CloudTrail [delegated administrator](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-delegated-administrator.html).
 */
public suspend inline fun CloudTrailClient.registerOrganizationDelegatedAdmin(crossinline block: RegisterOrganizationDelegatedAdminRequest.Builder.() -> Unit): RegisterOrganizationDelegatedAdminResponse = registerOrganizationDelegatedAdmin(RegisterOrganizationDelegatedAdminRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from a trail, event data store, dashboard, or channel.
 */
public suspend inline fun CloudTrailClient.removeTags(crossinline block: RemoveTagsRequest.Builder.() -> Unit): RemoveTagsResponse = removeTags(RemoveTagsRequest.Builder().apply(block).build())

/**
 * Restores a deleted event data store specified by `EventDataStore`, which accepts an event data store ARN. You can only restore a deleted event data store within the seven-day wait period after deletion. Restoring an event data store can take several minutes, depending on the size of the event data store.
 */
public suspend inline fun CloudTrailClient.restoreEventDataStore(crossinline block: RestoreEventDataStoreRequest.Builder.() -> Unit): RestoreEventDataStoreResponse = restoreEventDataStore(RestoreEventDataStoreRequest.Builder().apply(block).build())

/**
 * Searches sample queries and returns a list of sample queries that are sorted by relevance. To search for sample queries, provide a natural language `SearchPhrase` in English.
 */
public suspend inline fun CloudTrailClient.searchSampleQueries(crossinline block: SearchSampleQueriesRequest.Builder.() -> Unit): SearchSampleQueriesResponse = searchSampleQueries(SearchSampleQueriesRequest.Builder().apply(block).build())

/**
 * Starts a refresh of the specified dashboard.
 *
 *  Each time a dashboard is refreshed, CloudTrail runs queries to populate the dashboard's widgets. CloudTrail must be granted permissions to run the `StartQuery` operation on your behalf. To provide permissions, run the `PutResourcePolicy` operation to attach a resource-based policy to each event data store. For more information, see [Example: Allow CloudTrail to run queries to populate a dashboard](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard) in the *CloudTrail User Guide*.
 */
public suspend inline fun CloudTrailClient.startDashboardRefresh(crossinline block: StartDashboardRefreshRequest.Builder.() -> Unit): StartDashboardRefreshResponse = startDashboardRefresh(StartDashboardRefreshRequest.Builder().apply(block).build())

/**
 * Starts the ingestion of live events on an event data store specified as either an ARN or the ID portion of the ARN. To start ingestion, the event data store `Status` must be `STOPPED_INGESTION` and the `eventCategory` must be `Management`, `Data`, `NetworkActivity`, or `ConfigurationItem`.
 */
public suspend inline fun CloudTrailClient.startEventDataStoreIngestion(crossinline block: StartEventDataStoreIngestionRequest.Builder.() -> Unit): StartEventDataStoreIngestionResponse = startEventDataStoreIngestion(StartEventDataStoreIngestionRequest.Builder().apply(block).build())

/**
 * Starts an import of logged trail events from a source S3 bucket to a destination event data store. By default, CloudTrail only imports events contained in the S3 bucket's `CloudTrail` prefix and the prefixes inside the `CloudTrail` prefix, and does not check prefixes for other Amazon Web Services services. If you want to import CloudTrail events contained in another prefix, you must include the prefix in the `S3LocationUri`. For more considerations about importing trail events, see [Considerations for copying trail events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-copy-trail-to-lake.html#cloudtrail-trail-copy-considerations) in the *CloudTrail User Guide*.
 *
 *  When you start a new import, the `Destinations` and `ImportSource` parameters are required. Before starting a new import, disable any access control lists (ACLs) attached to the source S3 bucket. For more information about disabling ACLs, see [Controlling ownership of objects and disabling ACLs for your bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html).
 *
 *  When you retry an import, the `ImportID` parameter is required.
 *
 *  If the destination event data store is for an organization, you must use the management account to import trail events. You cannot use the delegated administrator account for the organization.
 */
public suspend inline fun CloudTrailClient.startImport(crossinline block: StartImportRequest.Builder.() -> Unit): StartImportResponse = startImport(StartImportRequest.Builder().apply(block).build())

/**
 * Starts the recording of Amazon Web Services API calls and log file delivery for a trail. For a trail that is enabled in all Regions, this operation must be called from the Region in which the trail was created. This operation cannot be called on the shadow trails (replicated trails in other Regions) of a trail that is enabled in all Regions.
 */
public suspend inline fun CloudTrailClient.startLogging(crossinline block: StartLoggingRequest.Builder.() -> Unit): StartLoggingResponse = startLogging(StartLoggingRequest.Builder().apply(block).build())

/**
 * Starts a CloudTrail Lake query. Use the `QueryStatement` parameter to provide your SQL query, enclosed in single quotation marks. Use the optional `DeliveryS3Uri` parameter to deliver the query results to an S3 bucket.
 *
 * `StartQuery` requires you specify either the `QueryStatement` parameter, or a `QueryAlias` and any `QueryParameters`. In the current release, the `QueryAlias` and `QueryParameters` parameters are used only for the queries that populate the CloudTrail Lake dashboards.
 */
public suspend inline fun CloudTrailClient.startQuery(crossinline block: StartQueryRequest.Builder.() -> Unit): StartQueryResponse = startQuery(StartQueryRequest.Builder().apply(block).build())

/**
 * Stops the ingestion of live events on an event data store specified as either an ARN or the ID portion of the ARN. To stop ingestion, the event data store `Status` must be `ENABLED` and the `eventCategory` must be `Management`, `Data`, `NetworkActivity`, or `ConfigurationItem`.
 */
public suspend inline fun CloudTrailClient.stopEventDataStoreIngestion(crossinline block: StopEventDataStoreIngestionRequest.Builder.() -> Unit): StopEventDataStoreIngestionResponse = stopEventDataStoreIngestion(StopEventDataStoreIngestionRequest.Builder().apply(block).build())

/**
 * Stops a specified import.
 */
public suspend inline fun CloudTrailClient.stopImport(crossinline block: StopImportRequest.Builder.() -> Unit): StopImportResponse = stopImport(StopImportRequest.Builder().apply(block).build())

/**
 * Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail. Under most circumstances, there is no need to use this action. You can update a trail without stopping it first. This action is the only way to stop recording. For a trail enabled in all Regions, this operation must be called from the Region in which the trail was created, or an `InvalidHomeRegionException` will occur. This operation cannot be called on the shadow trails (replicated trails in other Regions) of a trail enabled in all Regions.
 */
public suspend inline fun CloudTrailClient.stopLogging(crossinline block: StopLoggingRequest.Builder.() -> Unit): StopLoggingResponse = stopLogging(StopLoggingRequest.Builder().apply(block).build())

/**
 * Updates a channel specified by a required channel ARN or UUID.
 */
public suspend inline fun CloudTrailClient.updateChannel(crossinline block: UpdateChannelRequest.Builder.() -> Unit): UpdateChannelResponse = updateChannel(UpdateChannelRequest.Builder().apply(block).build())

/**
 * Updates the specified dashboard.
 *
 *  To set a refresh schedule, CloudTrail must be granted permissions to run the `StartDashboardRefresh` operation to refresh the dashboard on your behalf. To provide permissions, run the `PutResourcePolicy` operation to attach a resource-based policy to the dashboard. For more information, see [ Resource-based policy example for a dashboard](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-dashboards) in the *CloudTrail User Guide*.
 *
 *  CloudTrail runs queries to populate the dashboard's widgets during a manual or scheduled refresh. CloudTrail must be granted permissions to run the `StartQuery` operation on your behalf. To provide permissions, run the `PutResourcePolicy` operation to attach a resource-based policy to each event data store. For more information, see [Example: Allow CloudTrail to run queries to populate a dashboard](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard) in the *CloudTrail User Guide*.
 */
public suspend inline fun CloudTrailClient.updateDashboard(crossinline block: UpdateDashboardRequest.Builder.() -> Unit): UpdateDashboardResponse = updateDashboard(UpdateDashboardRequest.Builder().apply(block).build())

/**
 * Updates an event data store. The required `EventDataStore` value is an ARN or the ID portion of the ARN. Other parameters are optional, but at least one optional parameter must be specified, or CloudTrail throws an error. `RetentionPeriod` is in days, and valid values are integers between 7 and 3653 if the `BillingMode` is set to `EXTENDABLE_RETENTION_PRICING`, or between 7 and 2557 if `BillingMode` is set to `FIXED_RETENTION_PRICING`. By default, `TerminationProtection` is enabled.
 *
 * For event data stores for CloudTrail events, `AdvancedEventSelectors` includes or excludes management, data, or network activity events in your event data store. For more information about `AdvancedEventSelectors`, see [AdvancedEventSelectors](https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html).
 *
 *  For event data stores for CloudTrail Insights events, Config configuration items, Audit Manager evidence, or non-Amazon Web Services events, `AdvancedEventSelectors` includes events of that type in your event data store.
 */
public suspend inline fun CloudTrailClient.updateEventDataStore(crossinline block: UpdateEventDataStoreRequest.Builder.() -> Unit): UpdateEventDataStoreResponse = updateEventDataStore(UpdateEventDataStoreRequest.Builder().apply(block).build())

/**
 * Updates trail settings that control what events you are logging, and how to handle log files. Changes to a trail do not require stopping the CloudTrail service. Use this action to designate an existing bucket for log delivery. If the existing bucket has previously been a target for CloudTrail log files, an IAM policy exists for the bucket. `UpdateTrail` must be called from the Region in which the trail was created; otherwise, an `InvalidHomeRegionException` is thrown.
 */
public suspend inline fun CloudTrailClient.updateTrail(crossinline block: UpdateTrailRequest.Builder.() -> Unit): UpdateTrailResponse = updateTrail(UpdateTrailRequest.Builder().apply(block).build())
