// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.Destination
import aws.sdk.kotlin.services.cloudtrail.model.UpdateChannelResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class UpdateChannelOperationDeserializer: HttpDeserialize<UpdateChannelResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateChannelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateChannelError(context, call)
        }
        val builder = UpdateChannelResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateChannelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateChannelError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidEventDataStoreCategoryException" -> InvalidEventDataStoreCategoryExceptionDeserializer().deserialize(context, wrappedCall)
        "ChannelNotFoundException" -> ChannelNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "EventDataStoreNotFoundException" -> EventDataStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ChannelARNInvalidException" -> ChannelArnInvalidExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "InactiveEventDataStoreException" -> InactiveEventDataStoreExceptionDeserializer().deserialize(context, wrappedCall)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall)
        "ChannelAlreadyExistsException" -> ChannelAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "EventDataStoreARNInvalidException" -> EventDataStoreArnInvalidExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateChannelOperationBody(builder: UpdateChannelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHANNELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelArn"))
    val DESTINATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Destinations"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Source"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANNELARN_DESCRIPTOR)
        field(DESTINATIONS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANNELARN_DESCRIPTOR.index -> builder.channelArn = deserializeString()
                DESTINATIONS_DESCRIPTOR.index -> builder.destinations =
                    deserializer.deserializeList(DESTINATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Destination>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDestinationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SOURCE_DESCRIPTOR.index -> builder.source = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
