// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.AdvancedEventSelector
import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.EventSelector
import aws.sdk.kotlin.services.cloudtrail.model.PutEventSelectorsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class PutEventSelectorsOperationDeserializer: HttpDeserialize<PutEventSelectorsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PutEventSelectorsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutEventSelectorsError(context, call)
        }
        val builder = PutEventSelectorsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutEventSelectorsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPutEventSelectorsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "NotOrganizationMasterAccountException" -> NotOrganizationMasterAccountExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidTrailNameException" -> InvalidTrailNameExceptionDeserializer().deserialize(context, wrappedCall)
        "TrailNotFoundException" -> TrailNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidEventSelectorsException" -> InvalidEventSelectorsExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall)
        "NoManagementAccountSLRExistsException" -> NoManagementAccountSlrExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidHomeRegionException" -> InvalidHomeRegionExceptionDeserializer().deserialize(context, wrappedCall)
        "InsufficientDependencyServiceAccessPermissionException" -> InsufficientDependencyServiceAccessPermissionExceptionDeserializer().deserialize(context, wrappedCall)
        "CloudTrailARNInvalidException" -> CloudTrailArnInvalidExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutEventSelectorsOperationBody(builder: PutEventSelectorsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADVANCEDEVENTSELECTORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AdvancedEventSelectors"))
    val EVENTSELECTORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EventSelectors"))
    val TRAILARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrailARN"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADVANCEDEVENTSELECTORS_DESCRIPTOR)
        field(EVENTSELECTORS_DESCRIPTOR)
        field(TRAILARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADVANCEDEVENTSELECTORS_DESCRIPTOR.index -> builder.advancedEventSelectors =
                    deserializer.deserializeList(ADVANCEDEVENTSELECTORS_DESCRIPTOR) {
                        val col0 = mutableListOf<AdvancedEventSelector>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAdvancedEventSelectorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                EVENTSELECTORS_DESCRIPTOR.index -> builder.eventSelectors =
                    deserializer.deserializeList(EVENTSELECTORS_DESCRIPTOR) {
                        val col0 = mutableListOf<EventSelector>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEventSelectorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TRAILARN_DESCRIPTOR.index -> builder.trailArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
