// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.GetQueryResultsResponse
import aws.sdk.kotlin.services.cloudtrail.model.QueryStatistics
import aws.sdk.kotlin.services.cloudtrail.model.QueryStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetQueryResultsOperationDeserializer: HttpDeserialize<GetQueryResultsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetQueryResultsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetQueryResultsError(context, call)
        }
        val builder = GetQueryResultsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetQueryResultsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetQueryResultsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InsufficientEncryptionPolicyException" -> InsufficientEncryptionPolicyExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidMaxResultsException" -> InvalidMaxResultsExceptionDeserializer().deserialize(context, wrappedCall)
        "EventDataStoreNotFoundException" -> EventDataStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "NoManagementAccountSLRExistsException" -> NoManagementAccountSlrExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "QueryIdNotFoundException" -> QueryIdNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InactiveEventDataStoreException" -> InactiveEventDataStoreExceptionDeserializer().deserialize(context, wrappedCall)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall)
        "EventDataStoreARNInvalidException" -> EventDataStoreArnInvalidExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetQueryResultsOperationBody(builder: GetQueryResultsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorMessage"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val QUERYRESULTROWS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("QueryResultRows"))
    val QUERYRESULTROWS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val QUERYRESULTROWS_C1_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val QUERYSTATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("QueryStatistics"))
    val QUERYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("QueryStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERRORMESSAGE_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(QUERYRESULTROWS_DESCRIPTOR)
        field(QUERYSTATISTICS_DESCRIPTOR)
        field(QUERYSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                QUERYRESULTROWS_DESCRIPTOR.index -> builder.queryResultRows =
                    deserializer.deserializeList(QUERYRESULTROWS_DESCRIPTOR) {
                        val col0 = mutableListOf<List<Map<String, String>>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeList(QUERYRESULTROWS_C0_DESCRIPTOR) {
                                val col1 = mutableListOf<Map<String, String>>()
                                while (hasNextElement()) {
                                    val el1 = deserializer.deserializeMap(QUERYRESULTROWS_C1_DESCRIPTOR) {
                                        val map2 = mutableMapOf<String, String>()
                                        while (hasNextEntry()) {
                                            val k2 = key()
                                            val v2 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                            map2[k2] = v2
                                        }
                                        map2
                                    }
                                    col1.add(el1)
                                }
                                col1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                QUERYSTATISTICS_DESCRIPTOR.index -> builder.queryStatistics = deserializeQueryStatisticsDocument(deserializer)
                QUERYSTATUS_DESCRIPTOR.index -> builder.queryStatus = deserializeString().let { QueryStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
