// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeregisterOrganizationDelegatedAdminOperationDeserializer: HttpDeserialize<DeregisterOrganizationDelegatedAdminResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeregisterOrganizationDelegatedAdminResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeregisterOrganizationDelegatedAdminError(context, call)
        }
        val builder = DeregisterOrganizationDelegatedAdminResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeregisterOrganizationDelegatedAdminError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "NotOrganizationManagementAccountException" -> NotOrganizationManagementAccountExceptionDeserializer().deserialize(context, wrappedCall)
        "CloudTrailAccessNotEnabledException" -> CloudTrailAccessNotEnabledExceptionDeserializer().deserialize(context, wrappedCall)
        "AccountNotRegisteredException" -> AccountNotRegisteredExceptionDeserializer().deserialize(context, wrappedCall)
        "AccountNotFoundException" -> AccountNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "OrganizationNotInAllFeaturesModeException" -> OrganizationNotInAllFeaturesModeExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall)
        "OrganizationsNotInUseException" -> OrganizationsNotInUseExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall)
        "InsufficientDependencyServiceAccessPermissionException" -> InsufficientDependencyServiceAccessPermissionExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
