// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.DeleteResourcePolicyResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteResourcePolicyOperationDeserializer: HttpDeserialize<DeleteResourcePolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteResourcePolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteResourcePolicyError(context, call)
        }
        val builder = DeleteResourcePolicyResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteResourcePolicyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceARNNotValidException" -> ResourceArnNotValidExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceTypeNotSupportedException" -> ResourceTypeNotSupportedExceptionDeserializer().deserialize(context, wrappedCall)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourcePolicyNotFoundException" -> ResourcePolicyNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
