// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.serde

import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.DeleteEventDataStoreResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteEventDataStoreOperationDeserializer: HttpDeserialize<DeleteEventDataStoreResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteEventDataStoreResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteEventDataStoreError(context, call)
        }
        val builder = DeleteEventDataStoreResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteEventDataStoreError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "ChannelExistsForEDSException" -> ChannelExistsForEdsExceptionDeserializer().deserialize(context, wrappedCall)
        "EventDataStoreFederationEnabledException" -> EventDataStoreFederationEnabledExceptionDeserializer().deserialize(context, wrappedCall)
        "NotOrganizationMasterAccountException" -> NotOrganizationMasterAccountExceptionDeserializer().deserialize(context, wrappedCall)
        "EventDataStoreNotFoundException" -> EventDataStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InactiveEventDataStoreException" -> InactiveEventDataStoreExceptionDeserializer().deserialize(context, wrappedCall)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall)
        "EventDataStoreARNInvalidException" -> EventDataStoreArnInvalidExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall)
        "EventDataStoreHasOngoingImportException" -> EventDataStoreHasOngoingImportExceptionDeserializer().deserialize(context, wrappedCall)
        "NoManagementAccountSLRExistsException" -> NoManagementAccountSlrExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "EventDataStoreTerminationProtectedException" -> EventDataStoreTerminationProtectedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "InsufficientDependencyServiceAccessPermissionException" -> InsufficientDependencyServiceAccessPermissionExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
