// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model



/**
 * The settings for the source S3 bucket.
 */
public class S3ImportSource private constructor(builder: Builder) {
    /**
     * The IAM ARN role used to access the source S3 bucket.
     */
    public val s3BucketAccessRoleArn: kotlin.String = requireNotNull(builder.s3BucketAccessRoleArn) { "A non-null value must be provided for s3BucketAccessRoleArn" }
    /**
     * The Region associated with the source S3 bucket.
     */
    public val s3BucketRegion: kotlin.String = requireNotNull(builder.s3BucketRegion) { "A non-null value must be provided for s3BucketRegion" }
    /**
     * The URI for the source S3 bucket.
     */
    public val s3LocationUri: kotlin.String = requireNotNull(builder.s3LocationUri) { "A non-null value must be provided for s3LocationUri" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.S3ImportSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3ImportSource(")
        append("s3BucketAccessRoleArn=$s3BucketAccessRoleArn,")
        append("s3BucketRegion=$s3BucketRegion,")
        append("s3LocationUri=$s3LocationUri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3BucketAccessRoleArn.hashCode()
        result = 31 * result + (s3BucketRegion.hashCode())
        result = 31 * result + (s3LocationUri.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3ImportSource

        if (s3BucketAccessRoleArn != other.s3BucketAccessRoleArn) return false
        if (s3BucketRegion != other.s3BucketRegion) return false
        if (s3LocationUri != other.s3LocationUri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.S3ImportSource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The IAM ARN role used to access the source S3 bucket.
         */
        public var s3BucketAccessRoleArn: kotlin.String? = null
        /**
         * The Region associated with the source S3 bucket.
         */
        public var s3BucketRegion: kotlin.String? = null
        /**
         * The URI for the source S3 bucket.
         */
        public var s3LocationUri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.S3ImportSource) : this() {
            this.s3BucketAccessRoleArn = x.s3BucketAccessRoleArn
            this.s3BucketRegion = x.s3BucketRegion
            this.s3LocationUri = x.s3LocationUri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.S3ImportSource = S3ImportSource(this)

        internal fun correctErrors(): Builder {
            if (s3BucketAccessRoleArn == null) s3BucketAccessRoleArn = ""
            if (s3BucketRegion == null) s3BucketRegion = ""
            if (s3LocationUri == null) s3LocationUri = ""
            return this
        }
    }
}
