// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains a request for LookupEvents.
 */
public class LookupEventsRequest private constructor(builder: Builder) {
    /**
     * Specifies that only events that occur before or at the specified time are returned. If the specified end time is before the specified start time, an error is returned.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Specifies the event category. If you do not specify an event category, events of the category are not returned in the response. For example, if you do not specify `insight` as the value of `EventCategory`, no Insights events are returned.
     */
    public val eventCategory: aws.sdk.kotlin.services.cloudtrail.model.EventCategory? = builder.eventCategory
    /**
     * Contains a list of lookup attributes. Currently the list can contain only one item.
     */
    public val lookupAttributes: List<LookupAttribute>? = builder.lookupAttributes
    /**
     * The number of events to return. Possible values are 1 through 50. The default is 50.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the original call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Specifies that only events that occur after or at the specified time are returned. If the specified start time is after the specified end time, an error is returned.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.LookupEventsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LookupEventsRequest(")
        append("endTime=$endTime,")
        append("eventCategory=$eventCategory,")
        append("lookupAttributes=$lookupAttributes,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (eventCategory?.hashCode() ?: 0)
        result = 31 * result + (lookupAttributes?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LookupEventsRequest

        if (endTime != other.endTime) return false
        if (eventCategory != other.eventCategory) return false
        if (lookupAttributes != other.lookupAttributes) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.LookupEventsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies that only events that occur before or at the specified time are returned. If the specified end time is before the specified start time, an error is returned.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the event category. If you do not specify an event category, events of the category are not returned in the response. For example, if you do not specify `insight` as the value of `EventCategory`, no Insights events are returned.
         */
        public var eventCategory: aws.sdk.kotlin.services.cloudtrail.model.EventCategory? = null
        /**
         * Contains a list of lookup attributes. Currently the list can contain only one item.
         */
        public var lookupAttributes: List<LookupAttribute>? = null
        /**
         * The number of events to return. Possible values are 1 through 50. The default is 50.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the original call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Specifies that only events that occur after or at the specified time are returned. If the specified start time is after the specified end time, an error is returned.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.LookupEventsRequest) : this() {
            this.endTime = x.endTime
            this.eventCategory = x.eventCategory
            this.lookupAttributes = x.lookupAttributes
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.LookupEventsRequest = LookupEventsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
