// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * For `PutInsightSelectors`, this exception is thrown when the formatting or syntax of the `InsightSelectors` JSON statement is not valid, or the specified `InsightType` in the `InsightSelectors` statement is not valid. Valid values for `InsightType` are `ApiCallRateInsight` and `ApiErrorRateInsight`. To enable Insights on an event data store, the destination event data store specified by the `InsightsDestination` parameter must log Insights events and the source event data store specified by the `EventDataStore` parameter must log management events.
 *
 * For `UpdateEventDataStore`, this exception is thrown if Insights are enabled on the event data store and the updated advanced event selectors are not compatible with the configured `InsightSelectors`. If the `InsightSelectors` includes an `InsightType` of `ApiCallRateInsight`, the source event data store must log `write` management events. If the `InsightSelectors` includes an `InsightType` of `ApiErrorRateInsight`, the source event data store must log management events.
 */
public class InvalidInsightSelectorsException private constructor(builder: Builder) : CloudTrailException(builder.message) {

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.InvalidInsightSelectorsException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvalidInsightSelectorsException(")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvalidInsightSelectorsException

        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.InvalidInsightSelectorsException = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Brief description of the exception returned by the request.
         */
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.InvalidInsightSelectorsException) : this() {
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.InvalidInsightSelectorsException = InvalidInsightSelectorsException(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
