// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model



public class GetChannelResponse private constructor(builder: Builder) {
    /**
     * The ARN of an channel returned by a `GetChannel` request.
     */
    public val channelArn: kotlin.String? = builder.channelArn
    /**
     * The destinations for the channel. For channels created for integrations, the destinations are the event data stores that log events arriving through the channel. For service-linked channels, the destination is the Amazon Web Services service that created the service-linked channel to receive events.
     */
    public val destinations: List<Destination>? = builder.destinations
    /**
     * A table showing information about the most recent successful and failed attempts to ingest events.
     */
    public val ingestionStatus: aws.sdk.kotlin.services.cloudtrail.model.IngestionStatus? = builder.ingestionStatus
    /**
     * The name of the CloudTrail channel. For service-linked channels, the name is `aws-service-channel/service-name/custom-suffix` where `service-name` represents the name of the Amazon Web Services service that created the channel and `custom-suffix` represents the suffix generated by the Amazon Web Services service.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The source for the CloudTrail channel.
     */
    public val source: kotlin.String? = builder.source
    /**
     * Provides information about the advanced event selectors configured for the channel, and whether the channel applies to all Regions or a single Region.
     */
    public val sourceConfig: aws.sdk.kotlin.services.cloudtrail.model.SourceConfig? = builder.sourceConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.GetChannelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetChannelResponse(")
        append("channelArn=$channelArn,")
        append("destinations=$destinations,")
        append("ingestionStatus=$ingestionStatus,")
        append("name=$name,")
        append("source=$source,")
        append("sourceConfig=$sourceConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelArn?.hashCode() ?: 0
        result = 31 * result + (destinations?.hashCode() ?: 0)
        result = 31 * result + (ingestionStatus?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetChannelResponse

        if (channelArn != other.channelArn) return false
        if (destinations != other.destinations) return false
        if (ingestionStatus != other.ingestionStatus) return false
        if (name != other.name) return false
        if (source != other.source) return false
        if (sourceConfig != other.sourceConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.GetChannelResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of an channel returned by a `GetChannel` request.
         */
        public var channelArn: kotlin.String? = null
        /**
         * The destinations for the channel. For channels created for integrations, the destinations are the event data stores that log events arriving through the channel. For service-linked channels, the destination is the Amazon Web Services service that created the service-linked channel to receive events.
         */
        public var destinations: List<Destination>? = null
        /**
         * A table showing information about the most recent successful and failed attempts to ingest events.
         */
        public var ingestionStatus: aws.sdk.kotlin.services.cloudtrail.model.IngestionStatus? = null
        /**
         * The name of the CloudTrail channel. For service-linked channels, the name is `aws-service-channel/service-name/custom-suffix` where `service-name` represents the name of the Amazon Web Services service that created the channel and `custom-suffix` represents the suffix generated by the Amazon Web Services service.
         */
        public var name: kotlin.String? = null
        /**
         * The source for the CloudTrail channel.
         */
        public var source: kotlin.String? = null
        /**
         * Provides information about the advanced event selectors configured for the channel, and whether the channel applies to all Regions or a single Region.
         */
        public var sourceConfig: aws.sdk.kotlin.services.cloudtrail.model.SourceConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.GetChannelResponse) : this() {
            this.channelArn = x.channelArn
            this.destinations = x.destinations
            this.ingestionStatus = x.ingestionStatus
            this.name = x.name
            this.source = x.source
            this.sourceConfig = x.sourceConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.GetChannelResponse = GetChannelResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudtrail.model.IngestionStatus] inside the given [block]
         */
        public fun ingestionStatus(block: aws.sdk.kotlin.services.cloudtrail.model.IngestionStatus.Builder.() -> kotlin.Unit) {
            this.ingestionStatus = aws.sdk.kotlin.services.cloudtrail.model.IngestionStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudtrail.model.SourceConfig] inside the given [block]
         */
        public fun sourceConfig(block: aws.sdk.kotlin.services.cloudtrail.model.SourceConfig.Builder.() -> kotlin.Unit) {
            this.sourceConfig = aws.sdk.kotlin.services.cloudtrail.model.SourceConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
