// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model



/**
 * Use event selectors to further specify the management and data event settings for your trail. By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
 *
 * You can configure up to five event selectors for a trail.
 *
 * You cannot apply both event selectors and advanced event selectors to a trail.
 */
public class EventSelector private constructor(builder: Builder) {
    /**
     * CloudTrail supports data event logging for Amazon S3 objects, Lambda functions, and Amazon DynamoDB tables with basic event selectors. You can specify up to 250 resources for an individual event selector, but the total number of data resources cannot exceed 250 across all event selectors in a trail. This limit does not apply if you configure resource logging for all data events.
     *
     * For more information, see [Data Events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html) and [Limits in CloudTrail](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html) in the *CloudTrail User Guide*.
     */
    public val dataResources: List<DataResource>? = builder.dataResources
    /**
     * An optional list of service event sources from which you do not want management events to be logged on your trail. In this release, the list can be empty (disables the filter), or it can filter out Key Management Service or Amazon RDS Data API events by containing `kms.amazonaws.com` or `rdsdata.amazonaws.com`. By default, `ExcludeManagementEventSources` is empty, and KMS and Amazon RDS Data API events are logged to your trail. You can exclude management event sources only in Regions that support the event source.
     */
    public val excludeManagementEventSources: List<String>? = builder.excludeManagementEventSources
    /**
     * Specify if you want your event selector to include management events for your trail.
     *
     *  For more information, see [Management Events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
     *
     * By default, the value is `true`.
     *
     * The first copy of management events is free. You are charged for additional copies of management events that you are logging on any subsequent trail in the same Region. For more information about CloudTrail pricing, see [CloudTrail Pricing](http://aws.amazon.com/cloudtrail/pricing/).
     */
    public val includeManagementEvents: kotlin.Boolean? = builder.includeManagementEvents
    /**
     * Specify if you want your trail to log read-only events, write-only events, or all. For example, the EC2 `GetConsoleOutput` is a read-only API operation and `RunInstances` is a write-only API operation.
     *
     *  By default, the value is `All`.
     */
    public val readWriteType: aws.sdk.kotlin.services.cloudtrail.model.ReadWriteType? = builder.readWriteType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.EventSelector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventSelector(")
        append("dataResources=$dataResources,")
        append("excludeManagementEventSources=$excludeManagementEventSources,")
        append("includeManagementEvents=$includeManagementEvents,")
        append("readWriteType=$readWriteType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataResources?.hashCode() ?: 0
        result = 31 * result + (excludeManagementEventSources?.hashCode() ?: 0)
        result = 31 * result + (includeManagementEvents?.hashCode() ?: 0)
        result = 31 * result + (readWriteType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventSelector

        if (dataResources != other.dataResources) return false
        if (excludeManagementEventSources != other.excludeManagementEventSources) return false
        if (includeManagementEvents != other.includeManagementEvents) return false
        if (readWriteType != other.readWriteType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.EventSelector = Builder(this).apply(block).build()

    public class Builder {
        /**
         * CloudTrail supports data event logging for Amazon S3 objects, Lambda functions, and Amazon DynamoDB tables with basic event selectors. You can specify up to 250 resources for an individual event selector, but the total number of data resources cannot exceed 250 across all event selectors in a trail. This limit does not apply if you configure resource logging for all data events.
         *
         * For more information, see [Data Events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html) and [Limits in CloudTrail](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html) in the *CloudTrail User Guide*.
         */
        public var dataResources: List<DataResource>? = null
        /**
         * An optional list of service event sources from which you do not want management events to be logged on your trail. In this release, the list can be empty (disables the filter), or it can filter out Key Management Service or Amazon RDS Data API events by containing `kms.amazonaws.com` or `rdsdata.amazonaws.com`. By default, `ExcludeManagementEventSources` is empty, and KMS and Amazon RDS Data API events are logged to your trail. You can exclude management event sources only in Regions that support the event source.
         */
        public var excludeManagementEventSources: List<String>? = null
        /**
         * Specify if you want your event selector to include management events for your trail.
         *
         *  For more information, see [Management Events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
         *
         * By default, the value is `true`.
         *
         * The first copy of management events is free. You are charged for additional copies of management events that you are logging on any subsequent trail in the same Region. For more information about CloudTrail pricing, see [CloudTrail Pricing](http://aws.amazon.com/cloudtrail/pricing/).
         */
        public var includeManagementEvents: kotlin.Boolean? = null
        /**
         * Specify if you want your trail to log read-only events, write-only events, or all. For example, the EC2 `GetConsoleOutput` is a read-only API operation and `RunInstances` is a write-only API operation.
         *
         *  By default, the value is `All`.
         */
        public var readWriteType: aws.sdk.kotlin.services.cloudtrail.model.ReadWriteType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.EventSelector) : this() {
            this.dataResources = x.dataResources
            this.excludeManagementEventSources = x.excludeManagementEventSources
            this.includeManagementEvents = x.includeManagementEvents
            this.readWriteType = x.readWriteType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.EventSelector = EventSelector(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
