// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an event that was returned by a lookup request. The result includes a representation of a CloudTrail event.
 */
public class Event private constructor(builder: Builder) {
    /**
     * The Amazon Web Services access key ID that was used to sign the request. If the request was made with temporary security credentials, this is the access key ID of the temporary credentials.
     */
    public val accessKeyId: kotlin.String? = builder.accessKeyId
    /**
     * A JSON string that contains a representation of the event returned.
     */
    public val cloudTrailEvent: kotlin.String? = builder.cloudTrailEvent
    /**
     * The CloudTrail ID of the event returned.
     */
    public val eventId: kotlin.String? = builder.eventId
    /**
     * The name of the event returned.
     */
    public val eventName: kotlin.String? = builder.eventName
    /**
     * The Amazon Web Services service to which the request was made.
     */
    public val eventSource: kotlin.String? = builder.eventSource
    /**
     * The date and time of the event returned.
     */
    public val eventTime: aws.smithy.kotlin.runtime.time.Instant? = builder.eventTime
    /**
     * Information about whether the event is a write event or a read event.
     */
    public val readOnly: kotlin.String? = builder.readOnly
    /**
     * A list of resources referenced by the event returned.
     */
    public val resources: List<Resource>? = builder.resources
    /**
     * A user name or role name of the requester that called the API in the event returned.
     */
    public val username: kotlin.String? = builder.username

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.Event = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Event(")
        append("accessKeyId=$accessKeyId,")
        append("cloudTrailEvent=$cloudTrailEvent,")
        append("eventId=$eventId,")
        append("eventName=$eventName,")
        append("eventSource=$eventSource,")
        append("eventTime=$eventTime,")
        append("readOnly=$readOnly,")
        append("resources=$resources,")
        append("username=$username")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId?.hashCode() ?: 0
        result = 31 * result + (cloudTrailEvent?.hashCode() ?: 0)
        result = 31 * result + (eventId?.hashCode() ?: 0)
        result = 31 * result + (eventName?.hashCode() ?: 0)
        result = 31 * result + (eventSource?.hashCode() ?: 0)
        result = 31 * result + (eventTime?.hashCode() ?: 0)
        result = 31 * result + (readOnly?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Event

        if (accessKeyId != other.accessKeyId) return false
        if (cloudTrailEvent != other.cloudTrailEvent) return false
        if (eventId != other.eventId) return false
        if (eventName != other.eventName) return false
        if (eventSource != other.eventSource) return false
        if (eventTime != other.eventTime) return false
        if (readOnly != other.readOnly) return false
        if (resources != other.resources) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.Event = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services access key ID that was used to sign the request. If the request was made with temporary security credentials, this is the access key ID of the temporary credentials.
         */
        public var accessKeyId: kotlin.String? = null
        /**
         * A JSON string that contains a representation of the event returned.
         */
        public var cloudTrailEvent: kotlin.String? = null
        /**
         * The CloudTrail ID of the event returned.
         */
        public var eventId: kotlin.String? = null
        /**
         * The name of the event returned.
         */
        public var eventName: kotlin.String? = null
        /**
         * The Amazon Web Services service to which the request was made.
         */
        public var eventSource: kotlin.String? = null
        /**
         * The date and time of the event returned.
         */
        public var eventTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about whether the event is a write event or a read event.
         */
        public var readOnly: kotlin.String? = null
        /**
         * A list of resources referenced by the event returned.
         */
        public var resources: List<Resource>? = null
        /**
         * A user name or role name of the requester that called the API in the event returned.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.Event) : this() {
            this.accessKeyId = x.accessKeyId
            this.cloudTrailEvent = x.cloudTrailEvent
            this.eventId = x.eventId
            this.eventName = x.eventName
            this.eventSource = x.eventSource
            this.eventTime = x.eventTime
            this.readOnly = x.readOnly
            this.resources = x.resources
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.Event = Event(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
