// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model



/**
 * The Amazon S3 buckets, Lambda functions, or Amazon DynamoDB tables that you specify in your event selectors for your trail to log data events. Data events provide information about the resource operations performed on or within a resource itself. These are also known as data plane operations. You can specify up to 250 data resources for a trail.
 *
 * The total number of allowed data resources is 250. This number can be distributed between 1 and 5 event selectors, but the total cannot exceed 250 across all selectors for the trail.
 *
 * If you are using advanced event selectors, the maximum total number of values for all conditions, across all advanced event selectors for the trail, is 500.
 *
 * The following example demonstrates how logging works when you configure logging of all data events for an S3 bucket named `bucket-1`. In this example, the CloudTrail user specified an empty prefix, and the option to log both `Read` and `Write` data events.
 * + A user uploads an image file to `bucket-1`.
 * + The `PutObject` API operation is an Amazon S3 object-level API. It is recorded as a data event in CloudTrail. Because the CloudTrail user specified an S3 bucket with an empty prefix, events that occur on any object in that bucket are logged. The trail processes and logs the event.
 * + A user uploads an object to an Amazon S3 bucket named `arn:aws:s3:::bucket-2`.
 * + The `PutObject` API operation occurred for an object in an S3 bucket that the CloudTrail user didn't specify for the trail. The trail doesn’t log the event.
 *
 * The following example demonstrates how logging works when you configure logging of Lambda data events for a Lambda function named *MyLambdaFunction*, but not for all Lambda functions.
 * + A user runs a script that includes a call to the *MyLambdaFunction* function and the *MyOtherLambdaFunction* function.
 * + The `Invoke` API operation on *MyLambdaFunction* is an Lambda API. It is recorded as a data event in CloudTrail. Because the CloudTrail user specified logging data events for *MyLambdaFunction*, any invocations of that function are logged. The trail processes and logs the event.
 * + The `Invoke` API operation on *MyOtherLambdaFunction* is an Lambda API. Because the CloudTrail user did not specify logging data events for all Lambda functions, the `Invoke` operation for *MyOtherLambdaFunction* does not match the function specified for the trail. The trail doesn’t log the event.
 */
public class DataResource private constructor(builder: Builder) {
    /**
     * The resource type in which you want to log data events. You can specify the following *basic* event selector resource types:
     * + `AWS::DynamoDB::Table`
     * + `AWS::Lambda::Function`
     * + `AWS::S3::Object`
     *
     * Additional resource types are available through *advanced* event selectors. For more information about these additional resource types, see [AdvancedFieldSelector](https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedFieldSelector.html).
     */
    public val type: kotlin.String? = builder.type
    /**
     * An array of Amazon Resource Name (ARN) strings or partial ARN strings for the specified objects.
     * + To log data events for all objects in all S3 buckets in your Amazon Web Services account, specify the prefix as `arn:aws:s3`.This also enables logging of data event activity performed by any user or role in your Amazon Web Services account, even if that activity is performed on a bucket that belongs to another Amazon Web Services account.
     * + To log data events for all objects in an S3 bucket, specify the bucket and an empty object prefix such as `arn:aws:s3:::bucket-1/`. The trail logs data events for all objects in this S3 bucket.
     * + To log data events for specific objects, specify the S3 bucket and object prefix such as `arn:aws:s3:::bucket-1/example-images`. The trail logs data events for objects in this S3 bucket that match the prefix.
     * + To log data events for all Lambda functions in your Amazon Web Services account, specify the prefix as `arn:aws:lambda`.This also enables logging of `Invoke` activity performed by any user or role in your Amazon Web Services account, even if that activity is performed on a function that belongs to another Amazon Web Services account.
     * + To log data events for a specific Lambda function, specify the function ARN.Lambda function ARNs are exact. For example, if you specify a function ARN *arn:aws:lambda:us-west-2:111111111111:function:helloworld*, data events will only be logged for *arn:aws:lambda:us-west-2:111111111111:function:helloworld*. They will not be logged for *arn:aws:lambda:us-west-2:111111111111:function:helloworld2*.
     * + To log data events for all DynamoDB tables in your Amazon Web Services account, specify the prefix as `arn:aws:dynamodb`.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.DataResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataResource(")
        append("type=$type,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = type?.hashCode() ?: 0
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataResource

        if (type != other.type) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.DataResource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The resource type in which you want to log data events. You can specify the following *basic* event selector resource types:
         * + `AWS::DynamoDB::Table`
         * + `AWS::Lambda::Function`
         * + `AWS::S3::Object`
         *
         * Additional resource types are available through *advanced* event selectors. For more information about these additional resource types, see [AdvancedFieldSelector](https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedFieldSelector.html).
         */
        public var type: kotlin.String? = null
        /**
         * An array of Amazon Resource Name (ARN) strings or partial ARN strings for the specified objects.
         * + To log data events for all objects in all S3 buckets in your Amazon Web Services account, specify the prefix as `arn:aws:s3`.This also enables logging of data event activity performed by any user or role in your Amazon Web Services account, even if that activity is performed on a bucket that belongs to another Amazon Web Services account.
         * + To log data events for all objects in an S3 bucket, specify the bucket and an empty object prefix such as `arn:aws:s3:::bucket-1/`. The trail logs data events for all objects in this S3 bucket.
         * + To log data events for specific objects, specify the S3 bucket and object prefix such as `arn:aws:s3:::bucket-1/example-images`. The trail logs data events for objects in this S3 bucket that match the prefix.
         * + To log data events for all Lambda functions in your Amazon Web Services account, specify the prefix as `arn:aws:lambda`.This also enables logging of `Invoke` activity performed by any user or role in your Amazon Web Services account, even if that activity is performed on a function that belongs to another Amazon Web Services account.
         * + To log data events for a specific Lambda function, specify the function ARN.Lambda function ARNs are exact. For example, if you specify a function ARN *arn:aws:lambda:us-west-2:111111111111:function:helloworld*, data events will only be logged for *arn:aws:lambda:us-west-2:111111111111:function:helloworld*. They will not be logged for *arn:aws:lambda:us-west-2:111111111111:function:helloworld2*.
         * + To log data events for all DynamoDB tables in your Amazon Web Services account, specify the prefix as `arn:aws:dynamodb`.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.DataResource) : this() {
            this.type = x.type
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.DataResource = DataResource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
