// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model



public class CreateEventDataStoreRequest private constructor(builder: Builder) {
    /**
     * The advanced event selectors to use to select the events for the data store. You can configure up to five advanced event selectors for each event data store.
     *
     *  For more information about how to use advanced event selectors to log CloudTrail events, see [Log events by using advanced event selectors](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced) in the CloudTrail User Guide.
     *
     * For more information about how to use advanced event selectors to include Config configuration items in your event data store, see [Create an event data store for Config configuration items](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-eds-config) in the CloudTrail User Guide.
     *
     * For more information about how to use advanced event selectors to include non-Amazon Web Services events in your event data store, see [Create an integration to log events from outside Amazon Web Services](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-integration) in the CloudTrail User Guide.
     */
    public val advancedEventSelectors: List<AdvancedEventSelector>? = builder.advancedEventSelectors
    /**
     * The billing mode for the event data store determines the cost for ingesting events and the default and maximum retention period for the event data store.
     *
     * The following are the possible values:
     * + `EXTENDABLE_RETENTION_PRICING` - This billing mode is generally recommended if you want a flexible retention period of up to 3653 days (about 10 years). The default retention period for this billing mode is 366 days.
     * + `FIXED_RETENTION_PRICING` - This billing mode is recommended if you expect to ingest more than 25 TB of event data per month and need a retention period of up to 2557 days (about 7 years). The default retention period for this billing mode is 2557 days.
     *
     * The default value is `EXTENDABLE_RETENTION_PRICING`.
     *
     * For more information about CloudTrail pricing, see [CloudTrail Pricing](http://aws.amazon.com/cloudtrail/pricing/) and [Managing CloudTrail Lake costs](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-manage-costs.html).
     */
    public val billingMode: aws.sdk.kotlin.services.cloudtrail.model.BillingMode? = builder.billingMode
    /**
     * Specifies the KMS key ID to use to encrypt the events delivered by CloudTrail. The value can be an alias name prefixed by `alias/`, a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
     *
     * Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail from logging events to the event data store, and prevents users from querying the data in the event data store that was encrypted with the key. After you associate an event data store with a KMS key, the KMS key cannot be removed or changed. Before you disable or delete a KMS key that you are using with an event data store, delete or back up your event data store.
     *
     * CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see [Using multi-Region keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *Key Management Service Developer Guide*.
     *
     * Examples:
     * + `alias/MyAliasName`
     * + `arn:aws:kms:us-east-2:123456789012:alias/MyAliasName`
     * + `arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012`
     * + `12345678-1234-1234-1234-123456789012`
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies whether the event data store includes events from all Regions, or only from the Region in which the event data store is created.
     */
    public val multiRegionEnabled: kotlin.Boolean? = builder.multiRegionEnabled
    /**
     * The name of the event data store.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies whether an event data store collects events logged for an organization in Organizations.
     */
    public val organizationEnabled: kotlin.Boolean? = builder.organizationEnabled
    /**
     * The retention period of the event data store, in days. If `BillingMode` is set to `EXTENDABLE_RETENTION_PRICING`, you can set a retention period of up to 3653 days, the equivalent of 10 years. If `BillingMode` is set to `FIXED_RETENTION_PRICING`, you can set a retention period of up to 2557 days, the equivalent of seven years.
     *
     * CloudTrail Lake determines whether to retain an event by checking if the `eventTime` of the event is within the specified retention period. For example, if you set a retention period of 90 days, CloudTrail will remove events when the `eventTime` is older than 90 days.
     *
     * If you plan to copy trail events to this event data store, we recommend that you consider both the age of the events that you want to copy as well as how long you want to keep the copied events in your event data store. For example, if you copy trail events that are 5 years old and specify a retention period of 7 years, the event data store will retain those events for two years.
     */
    public val retentionPeriod: kotlin.Int? = builder.retentionPeriod
    /**
     * Specifies whether the event data store should start ingesting live events. The default is true.
     */
    public val startIngestion: kotlin.Boolean? = builder.startIngestion
    /**
     * A list of tags.
     */
    public val tagsList: List<Tag>? = builder.tagsList
    /**
     * Specifies whether termination protection is enabled for the event data store. If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
     */
    public val terminationProtectionEnabled: kotlin.Boolean? = builder.terminationProtectionEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.CreateEventDataStoreRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEventDataStoreRequest(")
        append("advancedEventSelectors=$advancedEventSelectors,")
        append("billingMode=$billingMode,")
        append("kmsKeyId=$kmsKeyId,")
        append("multiRegionEnabled=$multiRegionEnabled,")
        append("name=$name,")
        append("organizationEnabled=$organizationEnabled,")
        append("retentionPeriod=$retentionPeriod,")
        append("startIngestion=$startIngestion,")
        append("tagsList=$tagsList,")
        append("terminationProtectionEnabled=$terminationProtectionEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = advancedEventSelectors?.hashCode() ?: 0
        result = 31 * result + (billingMode?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (multiRegionEnabled?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (organizationEnabled?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod ?: 0)
        result = 31 * result + (startIngestion?.hashCode() ?: 0)
        result = 31 * result + (tagsList?.hashCode() ?: 0)
        result = 31 * result + (terminationProtectionEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEventDataStoreRequest

        if (advancedEventSelectors != other.advancedEventSelectors) return false
        if (billingMode != other.billingMode) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (multiRegionEnabled != other.multiRegionEnabled) return false
        if (name != other.name) return false
        if (organizationEnabled != other.organizationEnabled) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (startIngestion != other.startIngestion) return false
        if (tagsList != other.tagsList) return false
        if (terminationProtectionEnabled != other.terminationProtectionEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.CreateEventDataStoreRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The advanced event selectors to use to select the events for the data store. You can configure up to five advanced event selectors for each event data store.
         *
         *  For more information about how to use advanced event selectors to log CloudTrail events, see [Log events by using advanced event selectors](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced) in the CloudTrail User Guide.
         *
         * For more information about how to use advanced event selectors to include Config configuration items in your event data store, see [Create an event data store for Config configuration items](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-eds-config) in the CloudTrail User Guide.
         *
         * For more information about how to use advanced event selectors to include non-Amazon Web Services events in your event data store, see [Create an integration to log events from outside Amazon Web Services](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-integration) in the CloudTrail User Guide.
         */
        public var advancedEventSelectors: List<AdvancedEventSelector>? = null
        /**
         * The billing mode for the event data store determines the cost for ingesting events and the default and maximum retention period for the event data store.
         *
         * The following are the possible values:
         * + `EXTENDABLE_RETENTION_PRICING` - This billing mode is generally recommended if you want a flexible retention period of up to 3653 days (about 10 years). The default retention period for this billing mode is 366 days.
         * + `FIXED_RETENTION_PRICING` - This billing mode is recommended if you expect to ingest more than 25 TB of event data per month and need a retention period of up to 2557 days (about 7 years). The default retention period for this billing mode is 2557 days.
         *
         * The default value is `EXTENDABLE_RETENTION_PRICING`.
         *
         * For more information about CloudTrail pricing, see [CloudTrail Pricing](http://aws.amazon.com/cloudtrail/pricing/) and [Managing CloudTrail Lake costs](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-manage-costs.html).
         */
        public var billingMode: aws.sdk.kotlin.services.cloudtrail.model.BillingMode? = null
        /**
         * Specifies the KMS key ID to use to encrypt the events delivered by CloudTrail. The value can be an alias name prefixed by `alias/`, a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
         *
         * Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail from logging events to the event data store, and prevents users from querying the data in the event data store that was encrypted with the key. After you associate an event data store with a KMS key, the KMS key cannot be removed or changed. Before you disable or delete a KMS key that you are using with an event data store, delete or back up your event data store.
         *
         * CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see [Using multi-Region keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *Key Management Service Developer Guide*.
         *
         * Examples:
         * + `alias/MyAliasName`
         * + `arn:aws:kms:us-east-2:123456789012:alias/MyAliasName`
         * + `arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012`
         * + `12345678-1234-1234-1234-123456789012`
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies whether the event data store includes events from all Regions, or only from the Region in which the event data store is created.
         */
        public var multiRegionEnabled: kotlin.Boolean? = null
        /**
         * The name of the event data store.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies whether an event data store collects events logged for an organization in Organizations.
         */
        public var organizationEnabled: kotlin.Boolean? = null
        /**
         * The retention period of the event data store, in days. If `BillingMode` is set to `EXTENDABLE_RETENTION_PRICING`, you can set a retention period of up to 3653 days, the equivalent of 10 years. If `BillingMode` is set to `FIXED_RETENTION_PRICING`, you can set a retention period of up to 2557 days, the equivalent of seven years.
         *
         * CloudTrail Lake determines whether to retain an event by checking if the `eventTime` of the event is within the specified retention period. For example, if you set a retention period of 90 days, CloudTrail will remove events when the `eventTime` is older than 90 days.
         *
         * If you plan to copy trail events to this event data store, we recommend that you consider both the age of the events that you want to copy as well as how long you want to keep the copied events in your event data store. For example, if you copy trail events that are 5 years old and specify a retention period of 7 years, the event data store will retain those events for two years.
         */
        public var retentionPeriod: kotlin.Int? = null
        /**
         * Specifies whether the event data store should start ingesting live events. The default is true.
         */
        public var startIngestion: kotlin.Boolean? = null
        /**
         * A list of tags.
         */
        public var tagsList: List<Tag>? = null
        /**
         * Specifies whether termination protection is enabled for the event data store. If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
         */
        public var terminationProtectionEnabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.CreateEventDataStoreRequest) : this() {
            this.advancedEventSelectors = x.advancedEventSelectors
            this.billingMode = x.billingMode
            this.kmsKeyId = x.kmsKeyId
            this.multiRegionEnabled = x.multiRegionEnabled
            this.name = x.name
            this.organizationEnabled = x.organizationEnabled
            this.retentionPeriod = x.retentionPeriod
            this.startIngestion = x.startIngestion
            this.tagsList = x.tagsList
            this.terminationProtectionEnabled = x.terminationProtectionEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.CreateEventDataStoreRequest = CreateEventDataStoreRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
