// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model



/**
 * Advanced event selectors let you create fine-grained selectors for CloudTrail management and data events. They help you control costs by logging only those events that are important to you. For more information about advanced event selectors, see [Logging management events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html) and [Logging data events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
 *
 * You cannot apply both event selectors and advanced event selectors to a trail.
 *
 * **Supported CloudTrail event record fields for management events**
 * + `eventCategory` (required)
 * + `eventSource`
 * + `readOnly`
 *
 * **Supported CloudTrail event record fields for data events**
 * + `eventCategory` (required)
 * + `resources.type` (required)
 * + `readOnly`
 * + `eventName`
 * + `resources.ARN`
 *
 * For event data stores for CloudTrail Insights events, Config configuration items, Audit Manager evidence, or events outside of Amazon Web Services, the only supported field is `eventCategory`.
 */
public class AdvancedEventSelector private constructor(builder: Builder) {
    /**
     * Contains all selector statements in an advanced event selector.
     */
    public val fieldSelectors: List<AdvancedFieldSelector> = requireNotNull(builder.fieldSelectors) { "A non-null value must be provided for fieldSelectors" }
    /**
     * An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.AdvancedEventSelector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdvancedEventSelector(")
        append("fieldSelectors=$fieldSelectors,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fieldSelectors.hashCode()
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdvancedEventSelector

        if (fieldSelectors != other.fieldSelectors) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.AdvancedEventSelector = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains all selector statements in an advanced event selector.
         */
        public var fieldSelectors: List<AdvancedFieldSelector>? = null
        /**
         * An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.AdvancedEventSelector) : this() {
            this.fieldSelectors = x.fieldSelectors
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.AdvancedEventSelector = AdvancedEventSelector(this)

        internal fun correctErrors(): Builder {
            if (fieldSelectors == null) fieldSelectors = emptyList()
            return this
        }
    }
}
