// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.ListQueriesResponse
import aws.sdk.kotlin.services.cloudtrail.model.Query
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListQueriesOperationDeserializer: HttpDeserialize<ListQueriesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListQueriesResponse {
        if (!response.status.isSuccess()) {
            throwListQueriesError(context, response)
        }
        val builder = ListQueriesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListQueriesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListQueriesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EventDataStoreARNInvalidException" -> EventDataStoreArnInvalidExceptionDeserializer().deserialize(context, wrappedResponse)
        "EventDataStoreNotFoundException" -> EventDataStoreNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "InactiveEventDataStoreException" -> InactiveEventDataStoreExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidDateRangeException" -> InvalidDateRangeExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidMaxResultsException" -> InvalidMaxResultsExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidQueryStatusException" -> InvalidQueryStatusExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListQueriesOperationBody(builder: ListQueriesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val QUERIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Queries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(QUERIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                QUERIES_DESCRIPTOR.index -> builder.queries =
                    deserializer.deserializeList(QUERIES_DESCRIPTOR) {
                        val col0 = mutableListOf<Query>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeQueryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
