// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.GetTrailStatusResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetTrailStatusOperationDeserializer: HttpDeserialize<GetTrailStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetTrailStatusResponse {
        if (!response.status.isSuccess()) {
            throwGetTrailStatusError(context, response)
        }
        val builder = GetTrailStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetTrailStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetTrailStatusError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidTrailNameException" -> InvalidTrailNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedResponse)
        "TrailNotFoundException" -> TrailNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTrailStatusOperationBody(builder: GetTrailStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ISLOGGING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IsLogging"))
    val LATESTCLOUDWATCHLOGSDELIVERYERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestCloudWatchLogsDeliveryError"))
    val LATESTCLOUDWATCHLOGSDELIVERYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LatestCloudWatchLogsDeliveryTime"))
    val LATESTDELIVERYATTEMPTSUCCEEDED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestDeliveryAttemptSucceeded"))
    val LATESTDELIVERYATTEMPTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestDeliveryAttemptTime"))
    val LATESTDELIVERYERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestDeliveryError"))
    val LATESTDELIVERYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LatestDeliveryTime"))
    val LATESTDIGESTDELIVERYERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestDigestDeliveryError"))
    val LATESTDIGESTDELIVERYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LatestDigestDeliveryTime"))
    val LATESTNOTIFICATIONATTEMPTSUCCEEDED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestNotificationAttemptSucceeded"))
    val LATESTNOTIFICATIONATTEMPTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestNotificationAttemptTime"))
    val LATESTNOTIFICATIONERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LatestNotificationError"))
    val LATESTNOTIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LatestNotificationTime"))
    val STARTLOGGINGTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartLoggingTime"))
    val STOPLOGGINGTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StopLoggingTime"))
    val TIMELOGGINGSTARTED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TimeLoggingStarted"))
    val TIMELOGGINGSTOPPED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TimeLoggingStopped"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ISLOGGING_DESCRIPTOR)
        field(LATESTCLOUDWATCHLOGSDELIVERYERROR_DESCRIPTOR)
        field(LATESTCLOUDWATCHLOGSDELIVERYTIME_DESCRIPTOR)
        field(LATESTDELIVERYATTEMPTSUCCEEDED_DESCRIPTOR)
        field(LATESTDELIVERYATTEMPTTIME_DESCRIPTOR)
        field(LATESTDELIVERYERROR_DESCRIPTOR)
        field(LATESTDELIVERYTIME_DESCRIPTOR)
        field(LATESTDIGESTDELIVERYERROR_DESCRIPTOR)
        field(LATESTDIGESTDELIVERYTIME_DESCRIPTOR)
        field(LATESTNOTIFICATIONATTEMPTSUCCEEDED_DESCRIPTOR)
        field(LATESTNOTIFICATIONATTEMPTTIME_DESCRIPTOR)
        field(LATESTNOTIFICATIONERROR_DESCRIPTOR)
        field(LATESTNOTIFICATIONTIME_DESCRIPTOR)
        field(STARTLOGGINGTIME_DESCRIPTOR)
        field(STOPLOGGINGTIME_DESCRIPTOR)
        field(TIMELOGGINGSTARTED_DESCRIPTOR)
        field(TIMELOGGINGSTOPPED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ISLOGGING_DESCRIPTOR.index -> builder.isLogging = deserializeBoolean()
                LATESTCLOUDWATCHLOGSDELIVERYERROR_DESCRIPTOR.index -> builder.latestCloudWatchLogsDeliveryError = deserializeString()
                LATESTCLOUDWATCHLOGSDELIVERYTIME_DESCRIPTOR.index -> builder.latestCloudWatchLogsDeliveryTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LATESTDELIVERYATTEMPTSUCCEEDED_DESCRIPTOR.index -> builder.latestDeliveryAttemptSucceeded = deserializeString()
                LATESTDELIVERYATTEMPTTIME_DESCRIPTOR.index -> builder.latestDeliveryAttemptTime = deserializeString()
                LATESTDELIVERYERROR_DESCRIPTOR.index -> builder.latestDeliveryError = deserializeString()
                LATESTDELIVERYTIME_DESCRIPTOR.index -> builder.latestDeliveryTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LATESTDIGESTDELIVERYERROR_DESCRIPTOR.index -> builder.latestDigestDeliveryError = deserializeString()
                LATESTDIGESTDELIVERYTIME_DESCRIPTOR.index -> builder.latestDigestDeliveryTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LATESTNOTIFICATIONATTEMPTSUCCEEDED_DESCRIPTOR.index -> builder.latestNotificationAttemptSucceeded = deserializeString()
                LATESTNOTIFICATIONATTEMPTTIME_DESCRIPTOR.index -> builder.latestNotificationAttemptTime = deserializeString()
                LATESTNOTIFICATIONERROR_DESCRIPTOR.index -> builder.latestNotificationError = deserializeString()
                LATESTNOTIFICATIONTIME_DESCRIPTOR.index -> builder.latestNotificationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STARTLOGGINGTIME_DESCRIPTOR.index -> builder.startLoggingTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STOPLOGGINGTIME_DESCRIPTOR.index -> builder.stopLoggingTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                TIMELOGGINGSTARTED_DESCRIPTOR.index -> builder.timeLoggingStarted = deserializeString()
                TIMELOGGINGSTOPPED_DESCRIPTOR.index -> builder.timeLoggingStopped = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
