// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.GetQueryResultsResponse
import aws.sdk.kotlin.services.cloudtrail.model.QueryStatistics
import aws.sdk.kotlin.services.cloudtrail.model.QueryStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetQueryResultsOperationDeserializer: HttpDeserialize<GetQueryResultsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetQueryResultsResponse {
        if (!response.status.isSuccess()) {
            throwGetQueryResultsError(context, response)
        }
        val builder = GetQueryResultsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetQueryResultsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetQueryResultsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EventDataStoreARNInvalidException" -> EventDataStoreArnInvalidExceptionDeserializer().deserialize(context, wrappedResponse)
        "EventDataStoreNotFoundException" -> EventDataStoreNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "InactiveEventDataStoreException" -> InactiveEventDataStoreExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidMaxResultsException" -> InvalidMaxResultsExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedResponse)
        "QueryIdNotFoundException" -> QueryIdNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetQueryResultsOperationBody(builder: GetQueryResultsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorMessage"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val QUERYRESULTROWS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("QueryResultRows"))
    val QUERYRESULTROWS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val QUERYRESULTROWS_C1_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val QUERYSTATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("QueryStatistics"))
    val QUERYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERRORMESSAGE_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(QUERYRESULTROWS_DESCRIPTOR)
        field(QUERYSTATISTICS_DESCRIPTOR)
        field(QUERYSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                QUERYRESULTROWS_DESCRIPTOR.index -> builder.queryResultRows =
                    deserializer.deserializeList(QUERYRESULTROWS_DESCRIPTOR) {
                        val col0 = mutableListOf<List<Map<String, String>>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeList(QUERYRESULTROWS_C0_DESCRIPTOR) {
                                val col1 = mutableListOf<Map<String, String>>()
                                while (hasNextElement()) {
                                    val el1 = deserializer.deserializeMap(QUERYRESULTROWS_C1_DESCRIPTOR) {
                                        val map2 = mutableMapOf<String, String>()
                                        while (hasNextEntry()) {
                                            val k2 = key()
                                            val v2 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                            map2[k2] = v2
                                        }
                                        map2
                                    }
                                    col1.add(el1)
                                }
                                col1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                QUERYSTATISTICS_DESCRIPTOR.index -> builder.queryStatistics = deserializeQueryStatisticsDocument(deserializer)
                QUERYSTATUS_DESCRIPTOR.index -> builder.queryStatus = deserializeString().let { QueryStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
