// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.GetInsightSelectorsResponse
import aws.sdk.kotlin.services.cloudtrail.model.InsightSelector
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetInsightSelectorsOperationDeserializer: HttpDeserialize<GetInsightSelectorsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetInsightSelectorsResponse {
        if (!response.status.isSuccess()) {
            throwGetInsightSelectorsError(context, response)
        }
        val builder = GetInsightSelectorsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetInsightSelectorsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetInsightSelectorsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InsightNotEnabledException" -> InsightNotEnabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTrailNameException" -> InvalidTrailNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedResponse)
        "TrailNotFoundException" -> TrailNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetInsightSelectorsOperationBody(builder: GetInsightSelectorsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INSIGHTSELECTORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("InsightSelectors"))
    val TRAILARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrailARN"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INSIGHTSELECTORS_DESCRIPTOR)
        field(TRAILARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INSIGHTSELECTORS_DESCRIPTOR.index -> builder.insightSelectors =
                    deserializer.deserializeList(INSIGHTSELECTORS_DESCRIPTOR) {
                        val col0 = mutableListOf<InsightSelector>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInsightSelectorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TRAILARN_DESCRIPTOR.index -> builder.trailArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
