// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudtrail.model.AdvancedEventSelector
import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.EventDataStoreStatus
import aws.sdk.kotlin.services.cloudtrail.model.GetEventDataStoreResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetEventDataStoreOperationDeserializer: HttpDeserialize<GetEventDataStoreResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetEventDataStoreResponse {
        if (!response.status.isSuccess()) {
            throwGetEventDataStoreError(context, response)
        }
        val builder = GetEventDataStoreResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetEventDataStoreOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetEventDataStoreError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EventDataStoreARNInvalidException" -> EventDataStoreArnInvalidExceptionDeserializer().deserialize(context, wrappedResponse)
        "EventDataStoreNotFoundException" -> EventDataStoreNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEventDataStoreOperationBody(builder: GetEventDataStoreResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADVANCEDEVENTSELECTORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AdvancedEventSelectors"))
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTimestamp"))
    val EVENTDATASTOREARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EventDataStoreArn"))
    val MULTIREGIONENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("MultiRegionEnabled"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val ORGANIZATIONENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("OrganizationEnabled"))
    val RETENTIONPERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("RetentionPeriod"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TERMINATIONPROTECTIONENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("TerminationProtectionEnabled"))
    val UPDATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("UpdatedTimestamp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADVANCEDEVENTSELECTORS_DESCRIPTOR)
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(EVENTDATASTOREARN_DESCRIPTOR)
        field(MULTIREGIONENABLED_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ORGANIZATIONENABLED_DESCRIPTOR)
        field(RETENTIONPERIOD_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TERMINATIONPROTECTIONENABLED_DESCRIPTOR)
        field(UPDATEDTIMESTAMP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADVANCEDEVENTSELECTORS_DESCRIPTOR.index -> builder.advancedEventSelectors =
                    deserializer.deserializeList(ADVANCEDEVENTSELECTORS_DESCRIPTOR) {
                        val col0 = mutableListOf<AdvancedEventSelector>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAdvancedEventSelectorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                EVENTDATASTOREARN_DESCRIPTOR.index -> builder.eventDataStoreArn = deserializeString()
                MULTIREGIONENABLED_DESCRIPTOR.index -> builder.multiRegionEnabled = deserializeBoolean()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                ORGANIZATIONENABLED_DESCRIPTOR.index -> builder.organizationEnabled = deserializeBoolean()
                RETENTIONPERIOD_DESCRIPTOR.index -> builder.retentionPeriod = deserializeInt()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { EventDataStoreStatus.fromValue(it) }
                TERMINATIONPROTECTIONENABLED_DESCRIPTOR.index -> builder.terminationProtectionEnabled = deserializeBoolean()
                UPDATEDTIMESTAMP_DESCRIPTOR.index -> builder.updatedTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
