// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.DescribeTrailsResponse
import aws.sdk.kotlin.services.cloudtrail.model.Trail
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeTrailsOperationDeserializer: HttpDeserialize<DescribeTrailsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeTrailsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeTrailsError(context, response)
        }
        val builder = DescribeTrailsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeTrailsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeTrailsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidTrailNameException" -> InvalidTrailNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTrailsOperationBody(builder: DescribeTrailsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TRAILLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("trailList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TRAILLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TRAILLIST_DESCRIPTOR.index -> builder.trailList =
                    deserializer.deserializeList(TRAILLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<Trail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTrailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
