// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.DescribeQueryResponse
import aws.sdk.kotlin.services.cloudtrail.model.QueryStatisticsForDescribeQuery
import aws.sdk.kotlin.services.cloudtrail.model.QueryStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeQueryOperationDeserializer: HttpDeserialize<DescribeQueryResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeQueryResponse {
        if (!response.status.isSuccess()) {
            throwDescribeQueryError(context, response)
        }
        val builder = DescribeQueryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeQueryOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeQueryError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EventDataStoreARNInvalidException" -> EventDataStoreArnInvalidExceptionDeserializer().deserialize(context, wrappedResponse)
        "EventDataStoreNotFoundException" -> EventDataStoreNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "InactiveEventDataStoreException" -> InactiveEventDataStoreExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedResponse)
        "QueryIdNotFoundException" -> QueryIdNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeQueryOperationBody(builder: DescribeQueryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorMessage"))
    val QUERYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryId"))
    val QUERYSTATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("QueryStatistics"))
    val QUERYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryStatus"))
    val QUERYSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryString"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERRORMESSAGE_DESCRIPTOR)
        field(QUERYID_DESCRIPTOR)
        field(QUERYSTATISTICS_DESCRIPTOR)
        field(QUERYSTATUS_DESCRIPTOR)
        field(QUERYSTRING_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                QUERYID_DESCRIPTOR.index -> builder.queryId = deserializeString()
                QUERYSTATISTICS_DESCRIPTOR.index -> builder.queryStatistics = deserializeQueryStatisticsForDescribeQueryDocument(deserializer)
                QUERYSTATUS_DESCRIPTOR.index -> builder.queryStatus = deserializeString().let { QueryStatus.fromValue(it) }
                QUERYSTRING_DESCRIPTOR.index -> builder.queryString = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
