// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cloudtrail.model.CloudTrailException
import aws.sdk.kotlin.services.cloudtrail.model.CreateTrailResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateTrailOperationDeserializer: HttpDeserialize<CreateTrailResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateTrailResponse {
        if (!response.status.isSuccess()) {
            throwCreateTrailError(context, response)
        }
        val builder = CreateTrailResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateTrailOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateTrailError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CloudTrailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CloudTrailAccessNotEnabledException" -> CloudTrailAccessNotEnabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "CloudTrailInvalidClientTokenIdException" -> CloudTrailInvalidClientTokenIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "CloudWatchLogsDeliveryUnavailableException" -> CloudWatchLogsDeliveryUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InsufficientDependencyServiceAccessPermissionException" -> InsufficientDependencyServiceAccessPermissionExceptionDeserializer().deserialize(context, wrappedResponse)
        "InsufficientEncryptionPolicyException" -> InsufficientEncryptionPolicyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InsufficientS3BucketPolicyException" -> InsufficientS3BucketPolicyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InsufficientSnsTopicPolicyException" -> InsufficientSnsTopicPolicyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidCloudWatchLogsLogGroupArnException" -> InvalidCloudWatchLogsLogGroupArnExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidCloudWatchLogsRoleArnException" -> InvalidCloudWatchLogsRoleArnExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidKmsKeyIdException" -> InvalidKmsKeyIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterCombinationException" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidS3BucketNameException" -> InvalidS3BucketNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidS3PrefixException" -> InvalidS3PrefixExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSnsTopicNameException" -> InvalidSnsTopicNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTagParameterException" -> InvalidTagParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTrailNameException" -> InvalidTrailNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "KmsException" -> KmsExceptionDeserializer().deserialize(context, wrappedResponse)
        "KmsKeyDisabledException" -> KmsKeyDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "KmsKeyNotFoundException" -> KmsKeyNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "MaximumNumberOfTrailsExceededException" -> MaximumNumberOfTrailsExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotOrganizationMasterAccountException" -> NotOrganizationMasterAccountExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationNotInAllFeaturesModeException" -> OrganizationNotInAllFeaturesModeExceptionDeserializer().deserialize(context, wrappedResponse)
        "OrganizationsNotInUseException" -> OrganizationsNotInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "S3BucketDoesNotExistException" -> S3BucketDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "TrailAlreadyExistsException" -> TrailAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "TrailNotProvidedException" -> TrailNotProvidedExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudTrailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateTrailOperationBody(builder: CreateTrailResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLOUDWATCHLOGSLOGGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CloudWatchLogsLogGroupArn"))
    val CLOUDWATCHLOGSROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CloudWatchLogsRoleArn"))
    val INCLUDEGLOBALSERVICEEVENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IncludeGlobalServiceEvents"))
    val ISMULTIREGIONTRAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IsMultiRegionTrail"))
    val ISORGANIZATIONTRAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IsOrganizationTrail"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val LOGFILEVALIDATIONENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("LogFileValidationEnabled"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val S3BUCKETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3BucketName"))
    val S3KEYPREFIX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3KeyPrefix"))
    val SNSTOPICARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SnsTopicARN"))
    val SNSTOPICNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SnsTopicName"))
    val TRAILARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrailARN"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLOUDWATCHLOGSLOGGROUPARN_DESCRIPTOR)
        field(CLOUDWATCHLOGSROLEARN_DESCRIPTOR)
        field(INCLUDEGLOBALSERVICEEVENTS_DESCRIPTOR)
        field(ISMULTIREGIONTRAIL_DESCRIPTOR)
        field(ISORGANIZATIONTRAIL_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(LOGFILEVALIDATIONENABLED_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(S3BUCKETNAME_DESCRIPTOR)
        field(S3KEYPREFIX_DESCRIPTOR)
        field(SNSTOPICARN_DESCRIPTOR)
        field(SNSTOPICNAME_DESCRIPTOR)
        field(TRAILARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLOUDWATCHLOGSLOGGROUPARN_DESCRIPTOR.index -> builder.cloudWatchLogsLogGroupArn = deserializeString()
                CLOUDWATCHLOGSROLEARN_DESCRIPTOR.index -> builder.cloudWatchLogsRoleArn = deserializeString()
                INCLUDEGLOBALSERVICEEVENTS_DESCRIPTOR.index -> builder.includeGlobalServiceEvents = deserializeBoolean()
                ISMULTIREGIONTRAIL_DESCRIPTOR.index -> builder.isMultiRegionTrail = deserializeBoolean()
                ISORGANIZATIONTRAIL_DESCRIPTOR.index -> builder.isOrganizationTrail = deserializeBoolean()
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                LOGFILEVALIDATIONENABLED_DESCRIPTOR.index -> builder.logFileValidationEnabled = deserializeBoolean()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                S3BUCKETNAME_DESCRIPTOR.index -> builder.s3BucketName = deserializeString()
                S3KEYPREFIX_DESCRIPTOR.index -> builder.s3KeyPrefix = deserializeString()
                SNSTOPICARN_DESCRIPTOR.index -> builder.snsTopicArn = deserializeString()
                SNSTOPICNAME_DESCRIPTOR.index -> builder.snsTopicName = deserializeString()
                TRAILARN_DESCRIPTOR.index -> builder.trailArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
