// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.paginators

import aws.sdk.kotlin.services.cloudtrail.CloudTrailClient
import aws.sdk.kotlin.services.cloudtrail.model.Event
import aws.sdk.kotlin.services.cloudtrail.model.GetQueryResultsRequest
import aws.sdk.kotlin.services.cloudtrail.model.GetQueryResultsResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListEventDataStoresRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListEventDataStoresResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListPublicKeysRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListPublicKeysResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListQueriesRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListQueriesResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListTagsRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListTagsResponse
import aws.sdk.kotlin.services.cloudtrail.model.ListTrailsRequest
import aws.sdk.kotlin.services.cloudtrail.model.ListTrailsResponse
import aws.sdk.kotlin.services.cloudtrail.model.LookupEventsRequest
import aws.sdk.kotlin.services.cloudtrail.model.LookupEventsResponse
import aws.sdk.kotlin.services.cloudtrail.model.PublicKey
import aws.sdk.kotlin.services.cloudtrail.model.ResourceTag
import aws.sdk.kotlin.services.cloudtrail.model.TrailInfo
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetQueryResultsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetQueryResultsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetQueryResultsResponse]
 */
fun CloudTrailClient.getQueryResultsPaginated(initialRequest: GetQueryResultsRequest): Flow<GetQueryResultsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getQueryResultsPaginated.getQueryResults(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetQueryResultsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetQueryResultsResponse]
 */
fun CloudTrailClient.getQueryResultsPaginated(block: GetQueryResultsRequest.Builder.() -> Unit): Flow<GetQueryResultsResponse> =
    getQueryResultsPaginated(GetQueryResultsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListEventDataStoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEventDataStoresRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventDataStoresResponse]
 */
fun CloudTrailClient.listEventDataStoresPaginated(initialRequest: ListEventDataStoresRequest): Flow<ListEventDataStoresResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEventDataStoresPaginated.listEventDataStores(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListEventDataStoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventDataStoresResponse]
 */
fun CloudTrailClient.listEventDataStoresPaginated(block: ListEventDataStoresRequest.Builder.() -> Unit): Flow<ListEventDataStoresResponse> =
    listEventDataStoresPaginated(ListEventDataStoresRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPublicKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPublicKeysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPublicKeysResponse]
 */
fun CloudTrailClient.listPublicKeysPaginated(initialRequest: ListPublicKeysRequest): Flow<ListPublicKeysResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPublicKeysPaginated.listPublicKeys(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPublicKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPublicKeysResponse]
 */
fun CloudTrailClient.listPublicKeysPaginated(block: ListPublicKeysRequest.Builder.() -> Unit): Flow<ListPublicKeysResponse> =
    listPublicKeysPaginated(ListPublicKeysRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPublicKeysPaginated]
 * to access the nested member [PublicKey]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PublicKey]
 */
@JvmName("listPublicKeysResponsePublicKey")
fun Flow<ListPublicKeysResponse>.publicKeyList(): Flow<PublicKey> =
    transform() { response ->
        response.publicKeyList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListQueriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListQueriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueriesResponse]
 */
fun CloudTrailClient.listQueriesPaginated(initialRequest: ListQueriesRequest): Flow<ListQueriesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listQueriesPaginated.listQueries(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListQueriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueriesResponse]
 */
fun CloudTrailClient.listQueriesPaginated(block: ListQueriesRequest.Builder.() -> Unit): Flow<ListQueriesResponse> =
    listQueriesPaginated(ListQueriesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsResponse]
 */
fun CloudTrailClient.listTagsPaginated(initialRequest: ListTagsRequest): Flow<ListTagsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsPaginated.listTags(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsResponse]
 */
fun CloudTrailClient.listTagsPaginated(block: ListTagsRequest.Builder.() -> Unit): Flow<ListTagsResponse> =
    listTagsPaginated(ListTagsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsPaginated]
 * to access the nested member [ResourceTag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourceTag]
 */
@JvmName("listTagsResponseResourceTag")
fun Flow<ListTagsResponse>.resourceTagList(): Flow<ResourceTag> =
    transform() { response ->
        response.resourceTagList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTrailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTrailsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrailsResponse]
 */
fun CloudTrailClient.listTrailsPaginated(initialRequest: ListTrailsRequest): Flow<ListTrailsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTrailsPaginated.listTrails(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTrailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrailsResponse]
 */
fun CloudTrailClient.listTrailsPaginated(block: ListTrailsRequest.Builder.() -> Unit): Flow<ListTrailsResponse> =
    listTrailsPaginated(ListTrailsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTrailsPaginated]
 * to access the nested member [TrailInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TrailInfo]
 */
@JvmName("listTrailsResponseTrailInfo")
fun Flow<ListTrailsResponse>.trails(): Flow<TrailInfo> =
    transform() { response ->
        response.trails?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [LookupEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [LookupEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LookupEventsResponse]
 */
fun CloudTrailClient.lookupEventsPaginated(initialRequest: LookupEventsRequest): Flow<LookupEventsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@lookupEventsPaginated.lookupEvents(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [LookupEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LookupEventsResponse]
 */
fun CloudTrailClient.lookupEventsPaginated(block: LookupEventsRequest.Builder.() -> Unit): Flow<LookupEventsResponse> =
    lookupEventsPaginated(LookupEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [lookupEventsPaginated]
 * to access the nested member [Event]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Event]
 */
@JvmName("lookupEventsResponseEvent")
fun Flow<LookupEventsResponse>.events(): Flow<Event> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }
