// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model



/**
 * The settings for a trail.
 */
class Trail private constructor(builder: Builder) {
    /**
     * Specifies an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered.
     */
    val cloudWatchLogsLogGroupArn: kotlin.String? = builder.cloudWatchLogsLogGroupArn
    /**
     * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
     */
    val cloudWatchLogsRoleArn: kotlin.String? = builder.cloudWatchLogsRoleArn
    /**
     * Specifies if the trail has custom event selectors.
     */
    val hasCustomEventSelectors: kotlin.Boolean? = builder.hasCustomEventSelectors
    /**
     * Specifies whether a trail has insight types specified in an `InsightSelector` list.
     */
    val hasInsightSelectors: kotlin.Boolean? = builder.hasInsightSelectors
    /**
     * The region in which the trail was created.
     */
    val homeRegion: kotlin.String? = builder.homeRegion
    /**
     * Set to **True** to include Amazon Web Services API calls from Amazon Web Services global services such as IAM. Otherwise, **False**.
     */
    val includeGlobalServiceEvents: kotlin.Boolean? = builder.includeGlobalServiceEvents
    /**
     * Specifies whether the trail exists only in one region or exists in all regions.
     */
    val isMultiRegionTrail: kotlin.Boolean? = builder.isMultiRegionTrail
    /**
     * Specifies whether the trail is an organization trail.
     */
    val isOrganizationTrail: kotlin.Boolean? = builder.isOrganizationTrail
    /**
     * Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.
     *
     * `arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012`
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies whether log file validation is enabled.
     */
    val logFileValidationEnabled: kotlin.Boolean? = builder.logFileValidationEnabled
    /**
     * Name of the trail set by calling CreateTrail. The maximum length is 128 characters.
     */
    val name: kotlin.String? = builder.name
    /**
     * Name of the Amazon S3 bucket into which CloudTrail delivers your trail files. See [Amazon S3 Bucket Naming Requirements](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html).
     */
    val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see [Finding Your CloudTrail Log Files](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html). The maximum length is 200 characters.
     */
    val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix
    /**
     * Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The following is the format of a topic ARN.
     *
     * `arn:aws:sns:us-east-2:123456789012:MyTopic`
     */
    val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * This field is no longer in use. Use SnsTopicARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val snsTopicName: kotlin.String? = builder.snsTopicName
    /**
     * Specifies the ARN of the trail. The following is the format of a trail ARN.
     *
     * `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
     */
    val trailArn: kotlin.String? = builder.trailArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.Trail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Trail(")
        append("cloudWatchLogsLogGroupArn=$cloudWatchLogsLogGroupArn,")
        append("cloudWatchLogsRoleArn=$cloudWatchLogsRoleArn,")
        append("hasCustomEventSelectors=$hasCustomEventSelectors,")
        append("hasInsightSelectors=$hasInsightSelectors,")
        append("homeRegion=$homeRegion,")
        append("includeGlobalServiceEvents=$includeGlobalServiceEvents,")
        append("isMultiRegionTrail=$isMultiRegionTrail,")
        append("isOrganizationTrail=$isOrganizationTrail,")
        append("kmsKeyId=$kmsKeyId,")
        append("logFileValidationEnabled=$logFileValidationEnabled,")
        append("name=$name,")
        append("s3BucketName=$s3BucketName,")
        append("s3KeyPrefix=$s3KeyPrefix,")
        append("snsTopicArn=$snsTopicArn,")
        append("snsTopicName=$snsTopicName,")
        append("trailArn=$trailArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogsLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (cloudWatchLogsRoleArn?.hashCode() ?: 0)
        result = 31 * result + (hasCustomEventSelectors?.hashCode() ?: 0)
        result = 31 * result + (hasInsightSelectors?.hashCode() ?: 0)
        result = 31 * result + (homeRegion?.hashCode() ?: 0)
        result = 31 * result + (includeGlobalServiceEvents?.hashCode() ?: 0)
        result = 31 * result + (isMultiRegionTrail?.hashCode() ?: 0)
        result = 31 * result + (isOrganizationTrail?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (logFileValidationEnabled?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (snsTopicName?.hashCode() ?: 0)
        result = 31 * result + (trailArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Trail

        if (cloudWatchLogsLogGroupArn != other.cloudWatchLogsLogGroupArn) return false
        if (cloudWatchLogsRoleArn != other.cloudWatchLogsRoleArn) return false
        if (hasCustomEventSelectors != other.hasCustomEventSelectors) return false
        if (hasInsightSelectors != other.hasInsightSelectors) return false
        if (homeRegion != other.homeRegion) return false
        if (includeGlobalServiceEvents != other.includeGlobalServiceEvents) return false
        if (isMultiRegionTrail != other.isMultiRegionTrail) return false
        if (isOrganizationTrail != other.isOrganizationTrail) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (logFileValidationEnabled != other.logFileValidationEnabled) return false
        if (name != other.name) return false
        if (s3BucketName != other.s3BucketName) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (snsTopicName != other.snsTopicName) return false
        if (trailArn != other.trailArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.Trail = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered.
         */
        var cloudWatchLogsLogGroupArn: kotlin.String? = null
        /**
         * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
         */
        var cloudWatchLogsRoleArn: kotlin.String? = null
        /**
         * Specifies if the trail has custom event selectors.
         */
        var hasCustomEventSelectors: kotlin.Boolean? = null
        /**
         * Specifies whether a trail has insight types specified in an `InsightSelector` list.
         */
        var hasInsightSelectors: kotlin.Boolean? = null
        /**
         * The region in which the trail was created.
         */
        var homeRegion: kotlin.String? = null
        /**
         * Set to **True** to include Amazon Web Services API calls from Amazon Web Services global services such as IAM. Otherwise, **False**.
         */
        var includeGlobalServiceEvents: kotlin.Boolean? = null
        /**
         * Specifies whether the trail exists only in one region or exists in all regions.
         */
        var isMultiRegionTrail: kotlin.Boolean? = null
        /**
         * Specifies whether the trail is an organization trail.
         */
        var isOrganizationTrail: kotlin.Boolean? = null
        /**
         * Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.
         *
         * `arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012`
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * Specifies whether log file validation is enabled.
         */
        var logFileValidationEnabled: kotlin.Boolean? = null
        /**
         * Name of the trail set by calling CreateTrail. The maximum length is 128 characters.
         */
        var name: kotlin.String? = null
        /**
         * Name of the Amazon S3 bucket into which CloudTrail delivers your trail files. See [Amazon S3 Bucket Naming Requirements](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html).
         */
        var s3BucketName: kotlin.String? = null
        /**
         * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see [Finding Your CloudTrail Log Files](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html). The maximum length is 200 characters.
         */
        var s3KeyPrefix: kotlin.String? = null
        /**
         * Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The following is the format of a topic ARN.
         *
         * `arn:aws:sns:us-east-2:123456789012:MyTopic`
         */
        var snsTopicArn: kotlin.String? = null
        /**
         * This field is no longer in use. Use SnsTopicARN.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var snsTopicName: kotlin.String? = null
        /**
         * Specifies the ARN of the trail. The following is the format of a trail ARN.
         *
         * `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
         */
        var trailArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.Trail) : this() {
            this.cloudWatchLogsLogGroupArn = x.cloudWatchLogsLogGroupArn
            this.cloudWatchLogsRoleArn = x.cloudWatchLogsRoleArn
            this.hasCustomEventSelectors = x.hasCustomEventSelectors
            this.hasInsightSelectors = x.hasInsightSelectors
            this.homeRegion = x.homeRegion
            this.includeGlobalServiceEvents = x.includeGlobalServiceEvents
            this.isMultiRegionTrail = x.isMultiRegionTrail
            this.isOrganizationTrail = x.isOrganizationTrail
            this.kmsKeyId = x.kmsKeyId
            this.logFileValidationEnabled = x.logFileValidationEnabled
            this.name = x.name
            this.s3BucketName = x.s3BucketName
            this.s3KeyPrefix = x.s3KeyPrefix
            this.snsTopicArn = x.snsTopicArn
            this.snsTopicName = x.snsTopicName
            this.trailArn = x.trailArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.Trail = Trail(this)
    }
}
