// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model



/**
 * Specifies the tags to remove from a trail or event data store.
 */
class RemoveTagsRequest private constructor(builder: Builder) {
    /**
     * Specifies the ARN of the trail or event data store from which tags should be removed.
     *
     *  Example trail ARN format: `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
     *
     * Example event data store ARN format: `arn:aws:cloudtrail:us-east-2:12345678910:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE`
     */
    val resourceId: kotlin.String? = builder.resourceId
    /**
     * Specifies a list of tags to be removed.
     */
    val tagsList: List<Tag>? = builder.tagsList

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.RemoveTagsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RemoveTagsRequest(")
        append("resourceId=$resourceId,")
        append("tagsList=$tagsList)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceId?.hashCode() ?: 0
        result = 31 * result + (tagsList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RemoveTagsRequest

        if (resourceId != other.resourceId) return false
        if (tagsList != other.tagsList) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.RemoveTagsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the ARN of the trail or event data store from which tags should be removed.
         *
         *  Example trail ARN format: `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
         *
         * Example event data store ARN format: `arn:aws:cloudtrail:us-east-2:12345678910:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE`
         */
        var resourceId: kotlin.String? = null
        /**
         * Specifies a list of tags to be removed.
         */
        var tagsList: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.RemoveTagsRequest) : this() {
            this.resourceId = x.resourceId
            this.tagsList = x.tagsList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.RemoveTagsRequest = RemoveTagsRequest(this)
    }
}
