// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model



class PutEventSelectorsRequest private constructor(builder: Builder) {
    /**
     * Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You can use either `AdvancedEventSelectors` or `EventSelectors`, but not both. If you apply `AdvancedEventSelectors` to a trail, any existing `EventSelectors` are overwritten. For more information about advanced event selectors, see [Logging data events for trails](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
     */
    val advancedEventSelectors: List<AdvancedEventSelector>? = builder.advancedEventSelectors
    /**
     * Specifies the settings for your event selectors. You can configure up to five event selectors for a trail. You can use either `EventSelectors` or `AdvancedEventSelectors` in a `PutEventSelectors` request, but not both. If you apply `EventSelectors` to a trail, any existing `AdvancedEventSelectors` are overwritten.
     */
    val eventSelectors: List<EventSelector>? = builder.eventSelectors
    /**
     * Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:
     * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     * + Start with a letter or number, and end with a letter or number
     * + Be between 3 and 128 characters
     * + Have no adjacent periods, underscores or dashes. Names like `my-_namespace` and `my--namespace` are not valid.
     * + Not be in IP address format (for example, 192.168.5.4)
     *
     * If you specify a trail ARN, it must be in the following format.
     *
     * `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
     */
    val trailName: kotlin.String? = builder.trailName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.PutEventSelectorsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutEventSelectorsRequest(")
        append("advancedEventSelectors=$advancedEventSelectors,")
        append("eventSelectors=$eventSelectors,")
        append("trailName=$trailName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = advancedEventSelectors?.hashCode() ?: 0
        result = 31 * result + (eventSelectors?.hashCode() ?: 0)
        result = 31 * result + (trailName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutEventSelectorsRequest

        if (advancedEventSelectors != other.advancedEventSelectors) return false
        if (eventSelectors != other.eventSelectors) return false
        if (trailName != other.trailName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.PutEventSelectorsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You can use either `AdvancedEventSelectors` or `EventSelectors`, but not both. If you apply `AdvancedEventSelectors` to a trail, any existing `EventSelectors` are overwritten. For more information about advanced event selectors, see [Logging data events for trails](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html) in the *CloudTrail User Guide*.
         */
        var advancedEventSelectors: List<AdvancedEventSelector>? = null
        /**
         * Specifies the settings for your event selectors. You can configure up to five event selectors for a trail. You can use either `EventSelectors` or `AdvancedEventSelectors` in a `PutEventSelectors` request, but not both. If you apply `EventSelectors` to a trail, any existing `AdvancedEventSelectors` are overwritten.
         */
        var eventSelectors: List<EventSelector>? = null
        /**
         * Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:
         * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
         * + Start with a letter or number, and end with a letter or number
         * + Be between 3 and 128 characters
         * + Have no adjacent periods, underscores or dashes. Names like `my-_namespace` and `my--namespace` are not valid.
         * + Not be in IP address format (for example, 192.168.5.4)
         *
         * If you specify a trail ARN, it must be in the following format.
         *
         * `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
         */
        var trailName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.PutEventSelectorsRequest) : this() {
            this.advancedEventSelectors = x.advancedEventSelectors
            this.eventSelectors = x.eventSelectors
            this.trailName = x.trailName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.PutEventSelectorsRequest = PutEventSelectorsRequest(this)
    }
}
