// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a returned public key.
 */
class PublicKey private constructor(builder: Builder) {
    /**
     * The fingerprint of the public key.
     */
    val fingerprint: kotlin.String? = builder.fingerprint
    /**
     * The ending time of validity of the public key.
     */
    val validityEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.validityEndTime
    /**
     * The starting time of validity of the public key.
     */
    val validityStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.validityStartTime
    /**
     * The DER encoded public key value in PKCS#1 format.
     */
    val value: kotlin.ByteArray? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.PublicKey = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PublicKey(")
        append("fingerprint=$fingerprint,")
        append("validityEndTime=$validityEndTime,")
        append("validityStartTime=$validityStartTime,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fingerprint?.hashCode() ?: 0
        result = 31 * result + (validityEndTime?.hashCode() ?: 0)
        result = 31 * result + (validityStartTime?.hashCode() ?: 0)
        result = 31 * result + (value?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PublicKey

        if (fingerprint != other.fingerprint) return false
        if (validityEndTime != other.validityEndTime) return false
        if (validityStartTime != other.validityStartTime) return false
        if (value != null) {
            if (other.value == null) return false
            if (!value.contentEquals(other.value)) return false
        } else if (other.value != null) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.PublicKey = Builder(this).apply(block).build()

    class Builder {
        /**
         * The fingerprint of the public key.
         */
        var fingerprint: kotlin.String? = null
        /**
         * The ending time of validity of the public key.
         */
        var validityEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The starting time of validity of the public key.
         */
        var validityStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The DER encoded public key value in PKCS#1 format.
         */
        var value: kotlin.ByteArray? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.PublicKey) : this() {
            this.fingerprint = x.fingerprint
            this.validityEndTime = x.validityEndTime
            this.validityStartTime = x.validityStartTime
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.PublicKey = PublicKey(this)
    }
}
