// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model



/**
 * Returns the objects or data listed below if successful. Otherwise, returns an error.
 */
class CreateTrailResponse private constructor(builder: Builder) {
    /**
     * Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs will be delivered.
     */
    val cloudWatchLogsLogGroupArn: kotlin.String? = builder.cloudWatchLogsLogGroupArn
    /**
     * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
     */
    val cloudWatchLogsRoleArn: kotlin.String? = builder.cloudWatchLogsRoleArn
    /**
     * Specifies whether the trail is publishing events from global services such as IAM to the log files.
     */
    val includeGlobalServiceEvents: kotlin.Boolean? = builder.includeGlobalServiceEvents
    /**
     * Specifies whether the trail exists in one region or in all regions.
     */
    val isMultiRegionTrail: kotlin.Boolean? = builder.isMultiRegionTrail
    /**
     * Specifies whether the trail is an organization trail.
     */
    val isOrganizationTrail: kotlin.Boolean? = builder.isOrganizationTrail
    /**
     * Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.
     *
     * `arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012`
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies whether log file integrity validation is enabled.
     */
    val logFileValidationEnabled: kotlin.Boolean? = builder.logFileValidationEnabled
    /**
     * Specifies the name of the trail.
     */
    val name: kotlin.String? = builder.name
    /**
     * Specifies the name of the Amazon S3 bucket designated for publishing log files.
     */
    val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see [Finding Your CloudTrail Log Files](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
     */
    val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix
    /**
     * Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The format of a topic ARN is:
     *
     * `arn:aws:sns:us-east-2:123456789012:MyTopic`
     */
    val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * This field is no longer in use. Use SnsTopicARN.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val snsTopicName: kotlin.String? = builder.snsTopicName
    /**
     * Specifies the ARN of the trail that was created. The format of a trail ARN is:
     *
     * `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
     */
    val trailArn: kotlin.String? = builder.trailArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.CreateTrailResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTrailResponse(")
        append("cloudWatchLogsLogGroupArn=$cloudWatchLogsLogGroupArn,")
        append("cloudWatchLogsRoleArn=$cloudWatchLogsRoleArn,")
        append("includeGlobalServiceEvents=$includeGlobalServiceEvents,")
        append("isMultiRegionTrail=$isMultiRegionTrail,")
        append("isOrganizationTrail=$isOrganizationTrail,")
        append("kmsKeyId=$kmsKeyId,")
        append("logFileValidationEnabled=$logFileValidationEnabled,")
        append("name=$name,")
        append("s3BucketName=$s3BucketName,")
        append("s3KeyPrefix=$s3KeyPrefix,")
        append("snsTopicArn=$snsTopicArn,")
        append("snsTopicName=$snsTopicName,")
        append("trailArn=$trailArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogsLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (cloudWatchLogsRoleArn?.hashCode() ?: 0)
        result = 31 * result + (includeGlobalServiceEvents?.hashCode() ?: 0)
        result = 31 * result + (isMultiRegionTrail?.hashCode() ?: 0)
        result = 31 * result + (isOrganizationTrail?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (logFileValidationEnabled?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (snsTopicName?.hashCode() ?: 0)
        result = 31 * result + (trailArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTrailResponse

        if (cloudWatchLogsLogGroupArn != other.cloudWatchLogsLogGroupArn) return false
        if (cloudWatchLogsRoleArn != other.cloudWatchLogsRoleArn) return false
        if (includeGlobalServiceEvents != other.includeGlobalServiceEvents) return false
        if (isMultiRegionTrail != other.isMultiRegionTrail) return false
        if (isOrganizationTrail != other.isOrganizationTrail) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (logFileValidationEnabled != other.logFileValidationEnabled) return false
        if (name != other.name) return false
        if (s3BucketName != other.s3BucketName) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (snsTopicName != other.snsTopicName) return false
        if (trailArn != other.trailArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.CreateTrailResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs will be delivered.
         */
        var cloudWatchLogsLogGroupArn: kotlin.String? = null
        /**
         * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
         */
        var cloudWatchLogsRoleArn: kotlin.String? = null
        /**
         * Specifies whether the trail is publishing events from global services such as IAM to the log files.
         */
        var includeGlobalServiceEvents: kotlin.Boolean? = null
        /**
         * Specifies whether the trail exists in one region or in all regions.
         */
        var isMultiRegionTrail: kotlin.Boolean? = null
        /**
         * Specifies whether the trail is an organization trail.
         */
        var isOrganizationTrail: kotlin.Boolean? = null
        /**
         * Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.
         *
         * `arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012`
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * Specifies whether log file integrity validation is enabled.
         */
        var logFileValidationEnabled: kotlin.Boolean? = null
        /**
         * Specifies the name of the trail.
         */
        var name: kotlin.String? = null
        /**
         * Specifies the name of the Amazon S3 bucket designated for publishing log files.
         */
        var s3BucketName: kotlin.String? = null
        /**
         * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see [Finding Your CloudTrail Log Files](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
         */
        var s3KeyPrefix: kotlin.String? = null
        /**
         * Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The format of a topic ARN is:
         *
         * `arn:aws:sns:us-east-2:123456789012:MyTopic`
         */
        var snsTopicArn: kotlin.String? = null
        /**
         * This field is no longer in use. Use SnsTopicARN.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var snsTopicName: kotlin.String? = null
        /**
         * Specifies the ARN of the trail that was created. The format of a trail ARN is:
         *
         * `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
         */
        var trailArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.CreateTrailResponse) : this() {
            this.cloudWatchLogsLogGroupArn = x.cloudWatchLogsLogGroupArn
            this.cloudWatchLogsRoleArn = x.cloudWatchLogsRoleArn
            this.includeGlobalServiceEvents = x.includeGlobalServiceEvents
            this.isMultiRegionTrail = x.isMultiRegionTrail
            this.isOrganizationTrail = x.isOrganizationTrail
            this.kmsKeyId = x.kmsKeyId
            this.logFileValidationEnabled = x.logFileValidationEnabled
            this.name = x.name
            this.s3BucketName = x.s3BucketName
            this.s3KeyPrefix = x.s3KeyPrefix
            this.snsTopicArn = x.snsTopicArn
            this.snsTopicName = x.snsTopicName
            this.trailArn = x.trailArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.CreateTrailResponse = CreateTrailResponse(this)
    }
}
