// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model



/**
 * Specifies the settings for each trail.
 */
class CreateTrailRequest private constructor(builder: Builder) {
    /**
     * Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered. Not required unless you specify `CloudWatchLogsRoleArn`.
     */
    val cloudWatchLogsLogGroupArn: kotlin.String? = builder.cloudWatchLogsLogGroupArn
    /**
     * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
     */
    val cloudWatchLogsRoleArn: kotlin.String? = builder.cloudWatchLogsRoleArn
    /**
     * Specifies whether log file integrity validation is enabled. The default is false.
     *
     * When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.
     */
    val enableLogFileValidation: kotlin.Boolean? = builder.enableLogFileValidation
    /**
     * Specifies whether the trail is publishing events from global services such as IAM to the log files.
     */
    val includeGlobalServiceEvents: kotlin.Boolean? = builder.includeGlobalServiceEvents
    /**
     * Specifies whether the trail is created in the current region or in all regions. The default is false, which creates a trail only in the region where you are signed in. As a best practice, consider creating trails that log events in all regions.
     */
    val isMultiRegionTrail: kotlin.Boolean? = builder.isMultiRegionTrail
    /**
     * Specifies whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account. The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in Organizations.
     */
    val isOrganizationTrail: kotlin.Boolean? = builder.isOrganizationTrail
    /**
     * Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
     *
     * CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see [Using multi-Region keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *Key Management Service Developer Guide*.
     *
     * Examples:
     * + alias/MyAliasName
     * + arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
     * + arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
     * + 12345678-1234-1234-1234-123456789012
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies the name of the trail. The name must meet the following requirements:
     * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     * + Start with a letter or number, and end with a letter or number
     * + Be between 3 and 128 characters
     * + Have no adjacent periods, underscores or dashes. Names like `my-_namespace` and `my--namespace` are not valid.
     * + Not be in IP address format (for example, 192.168.5.4)
     */
    val name: kotlin.String? = builder.name
    /**
     * Specifies the name of the Amazon S3 bucket designated for publishing log files. See [Amazon S3 Bucket Naming Requirements](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html).
     */
    val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see [Finding Your CloudTrail Log Files](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html). The maximum length is 200 characters.
     */
    val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix
    /**
     * Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.
     */
    val snsTopicName: kotlin.String? = builder.snsTopicName
    /**
     * A list of tags.
     */
    val tagsList: List<Tag>? = builder.tagsList

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.CreateTrailRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTrailRequest(")
        append("cloudWatchLogsLogGroupArn=$cloudWatchLogsLogGroupArn,")
        append("cloudWatchLogsRoleArn=$cloudWatchLogsRoleArn,")
        append("enableLogFileValidation=$enableLogFileValidation,")
        append("includeGlobalServiceEvents=$includeGlobalServiceEvents,")
        append("isMultiRegionTrail=$isMultiRegionTrail,")
        append("isOrganizationTrail=$isOrganizationTrail,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("s3BucketName=$s3BucketName,")
        append("s3KeyPrefix=$s3KeyPrefix,")
        append("snsTopicName=$snsTopicName,")
        append("tagsList=$tagsList)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogsLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (cloudWatchLogsRoleArn?.hashCode() ?: 0)
        result = 31 * result + (enableLogFileValidation?.hashCode() ?: 0)
        result = 31 * result + (includeGlobalServiceEvents?.hashCode() ?: 0)
        result = 31 * result + (isMultiRegionTrail?.hashCode() ?: 0)
        result = 31 * result + (isOrganizationTrail?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (snsTopicName?.hashCode() ?: 0)
        result = 31 * result + (tagsList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTrailRequest

        if (cloudWatchLogsLogGroupArn != other.cloudWatchLogsLogGroupArn) return false
        if (cloudWatchLogsRoleArn != other.cloudWatchLogsRoleArn) return false
        if (enableLogFileValidation != other.enableLogFileValidation) return false
        if (includeGlobalServiceEvents != other.includeGlobalServiceEvents) return false
        if (isMultiRegionTrail != other.isMultiRegionTrail) return false
        if (isOrganizationTrail != other.isOrganizationTrail) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (s3BucketName != other.s3BucketName) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false
        if (snsTopicName != other.snsTopicName) return false
        if (tagsList != other.tagsList) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.CreateTrailRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered. Not required unless you specify `CloudWatchLogsRoleArn`.
         */
        var cloudWatchLogsLogGroupArn: kotlin.String? = null
        /**
         * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
         */
        var cloudWatchLogsRoleArn: kotlin.String? = null
        /**
         * Specifies whether log file integrity validation is enabled. The default is false.
         *
         * When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.
         */
        var enableLogFileValidation: kotlin.Boolean? = null
        /**
         * Specifies whether the trail is publishing events from global services such as IAM to the log files.
         */
        var includeGlobalServiceEvents: kotlin.Boolean? = null
        /**
         * Specifies whether the trail is created in the current region or in all regions. The default is false, which creates a trail only in the region where you are signed in. As a best practice, consider creating trails that log events in all regions.
         */
        var isMultiRegionTrail: kotlin.Boolean? = null
        /**
         * Specifies whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account. The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in Organizations.
         */
        var isOrganizationTrail: kotlin.Boolean? = null
        /**
         * Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
         *
         * CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see [Using multi-Region keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *Key Management Service Developer Guide*.
         *
         * Examples:
         * + alias/MyAliasName
         * + arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
         * + arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
         * + 12345678-1234-1234-1234-123456789012
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * Specifies the name of the trail. The name must meet the following requirements:
         * + Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
         * + Start with a letter or number, and end with a letter or number
         * + Be between 3 and 128 characters
         * + Have no adjacent periods, underscores or dashes. Names like `my-_namespace` and `my--namespace` are not valid.
         * + Not be in IP address format (for example, 192.168.5.4)
         */
        var name: kotlin.String? = null
        /**
         * Specifies the name of the Amazon S3 bucket designated for publishing log files. See [Amazon S3 Bucket Naming Requirements](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html).
         */
        var s3BucketName: kotlin.String? = null
        /**
         * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see [Finding Your CloudTrail Log Files](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html). The maximum length is 200 characters.
         */
        var s3KeyPrefix: kotlin.String? = null
        /**
         * Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.
         */
        var snsTopicName: kotlin.String? = null
        /**
         * A list of tags.
         */
        var tagsList: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.CreateTrailRequest) : this() {
            this.cloudWatchLogsLogGroupArn = x.cloudWatchLogsLogGroupArn
            this.cloudWatchLogsRoleArn = x.cloudWatchLogsRoleArn
            this.enableLogFileValidation = x.enableLogFileValidation
            this.includeGlobalServiceEvents = x.includeGlobalServiceEvents
            this.isMultiRegionTrail = x.isMultiRegionTrail
            this.isOrganizationTrail = x.isOrganizationTrail
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.s3BucketName = x.s3BucketName
            this.s3KeyPrefix = x.s3KeyPrefix
            this.snsTopicName = x.snsTopicName
            this.tagsList = x.tagsList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.CreateTrailRequest = CreateTrailRequest(this)
    }
}
