// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model



class CreateEventDataStoreRequest private constructor(builder: Builder) {
    /**
     * The advanced event selectors to use to select the events for the data store. For more information about how to use advanced event selectors, see [Log events by using advanced event selectors](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced) in the CloudTrail User Guide.
     */
    val advancedEventSelectors: List<AdvancedEventSelector>? = builder.advancedEventSelectors
    /**
     * Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created.
     */
    val multiRegionEnabled: kotlin.Boolean? = builder.multiRegionEnabled
    /**
     * The name of the event data store.
     */
    val name: kotlin.String? = builder.name
    /**
     * Specifies whether an event data store collects events logged for an organization in Organizations.
     */
    val organizationEnabled: kotlin.Boolean? = builder.organizationEnabled
    /**
     * The retention period of the event data store, in days. You can set a retention period of up to 2555 days, the equivalent of seven years.
     */
    val retentionPeriod: kotlin.Int? = builder.retentionPeriod
    /**
     * A list of tags.
     */
    val tagsList: List<Tag>? = builder.tagsList
    /**
     * Specifies whether termination protection is enabled for the event data store. If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
     */
    val terminationProtectionEnabled: kotlin.Boolean? = builder.terminationProtectionEnabled

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.CreateEventDataStoreRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEventDataStoreRequest(")
        append("advancedEventSelectors=$advancedEventSelectors,")
        append("multiRegionEnabled=$multiRegionEnabled,")
        append("name=$name,")
        append("organizationEnabled=$organizationEnabled,")
        append("retentionPeriod=$retentionPeriod,")
        append("tagsList=$tagsList,")
        append("terminationProtectionEnabled=$terminationProtectionEnabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = advancedEventSelectors?.hashCode() ?: 0
        result = 31 * result + (multiRegionEnabled?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (organizationEnabled?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod ?: 0)
        result = 31 * result + (tagsList?.hashCode() ?: 0)
        result = 31 * result + (terminationProtectionEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEventDataStoreRequest

        if (advancedEventSelectors != other.advancedEventSelectors) return false
        if (multiRegionEnabled != other.multiRegionEnabled) return false
        if (name != other.name) return false
        if (organizationEnabled != other.organizationEnabled) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (tagsList != other.tagsList) return false
        if (terminationProtectionEnabled != other.terminationProtectionEnabled) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.CreateEventDataStoreRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The advanced event selectors to use to select the events for the data store. For more information about how to use advanced event selectors, see [Log events by using advanced event selectors](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced) in the CloudTrail User Guide.
         */
        var advancedEventSelectors: List<AdvancedEventSelector>? = null
        /**
         * Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created.
         */
        var multiRegionEnabled: kotlin.Boolean? = null
        /**
         * The name of the event data store.
         */
        var name: kotlin.String? = null
        /**
         * Specifies whether an event data store collects events logged for an organization in Organizations.
         */
        var organizationEnabled: kotlin.Boolean? = null
        /**
         * The retention period of the event data store, in days. You can set a retention period of up to 2555 days, the equivalent of seven years.
         */
        var retentionPeriod: kotlin.Int? = null
        /**
         * A list of tags.
         */
        var tagsList: List<Tag>? = null
        /**
         * Specifies whether termination protection is enabled for the event data store. If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
         */
        var terminationProtectionEnabled: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.CreateEventDataStoreRequest) : this() {
            this.advancedEventSelectors = x.advancedEventSelectors
            this.multiRegionEnabled = x.multiRegionEnabled
            this.name = x.name
            this.organizationEnabled = x.organizationEnabled
            this.retentionPeriod = x.retentionPeriod
            this.tagsList = x.tagsList
            this.terminationProtectionEnabled = x.terminationProtectionEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.CreateEventDataStoreRequest = CreateEventDataStoreRequest(this)
    }
}
