// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudtrail.model



/**
 * A single selector statement in an advanced event selector.
 */
class AdvancedFieldSelector private constructor(builder: Builder) {
    /**
     * An operator that includes events that match the last few characters of the event record field specified as the value of `Field`.
     */
    val endsWith: List<String>? = builder.endsWith
    /**
     * An operator that includes events that match the exact value of the event record field specified as the value of `Field`. This is the only valid operator that you can use with the `readOnly`, `eventCategory`, and `resources.type` fields.
     */
    val equals: List<String>? = builder.equals
    /**
     * A field in an event record on which to filter events to be logged. Supported fields include `readOnly`, `eventCategory`, `eventSource` (for management events), `eventName`, `resources.type`, and `resources.ARN`.
     * + **`readOnly`** - Optional. Can be set to `Equals` a value of `true` or `false`. If you do not add this field, CloudTrail logs both both `read` and `write` events. A value of `true` logs only `read` events. A value of `false` logs only `write` events.
     * + **`eventSource`** - For filtering management events only. This can be set only to `NotEquals``kms.amazonaws.com`.
     * + **`eventName`** - Can use any operator. You can use it to ﬁlter in or ﬁlter out any data event logged to CloudTrail, such as `PutBucket` or `GetSnapshotBlock`. You can have multiple values for this ﬁeld, separated by commas.
     * + **`eventCategory`** - This is required. It must be set to `Equals`, and the value must be `Management` or `Data`.
     * + **`resources.type`** - This ﬁeld is required. `resources.type` can only use the `Equals` operator, and the value can be one of the following:
     *    + `AWS::S3::Object`
     *    + `AWS::Lambda::Function`
     *    + `AWS::DynamoDB::Table`
     *    + `AWS::S3Outposts::Object`
     *    + `AWS::ManagedBlockchain::Node`
     *    + `AWS::S3ObjectLambda::AccessPoint`
     *    + `AWS::EC2::Snapshot`
     *    + `AWS::S3::AccessPoint`
     *    + `AWS::DynamoDB::Stream`
     *    + `AWS::Glue::Table`
     *  You can have only one `resources.type` ﬁeld per selector. To log data events on more than one resource type, add another selector.
     * + **`resources.ARN`** - You can use any operator with `resources.ARN`, but if you use `Equals` or `NotEquals`, the value must exactly match the ARN of a valid resource of the type you've speciﬁed in the template as the value of resources.type. For example, if resources.type equals `AWS::S3::Object`, the ARN must be in one of the following formats. To log all data events for all objects in a specific S3 bucket, use the `StartsWith` operator, and include only the bucket ARN as the matching value.The trailing slash is intentional; do not exclude it. Replace the text between less than and greater than symbols (<>) with resource-specific information.
     *    + `arn:<partition>:s3:::<bucket_name>/`
     *    + `arn:<partition>:s3:::<bucket_name>/<object_path>/`
     * When `resources.type` equals `AWS::S3::AccessPoint`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in one of the following formats. To log events on all objects in an S3 access point, we recommend that you use only the access point ARN, don’t include the object path, and use the `StartsWith` or `NotStartsWith` operators.
     *    + `arn:<partition>:s3:<region>:<account_ID>:accesspoint/<access_point_name>`
     *    + `arn:<partition>:s3:<region>:<account_ID>:accesspoint/<access_point_name>/object/<object_path>`
     * When resources.type equals `AWS::Lambda::Function`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in the following format:
     *    + `arn:<partition>:lambda:<region>:<account_ID>:function:<function_name>`
     * When resources.type equals `AWS::DynamoDB::Table`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in the following format:
     *    + `arn:<partition>:dynamodb:<region>:<account_ID>:table/<table_name>`
     * When `resources.type` equals `AWS::S3Outposts::Object`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in the following format:
     *    + `arn:<partition>:s3-outposts:<region>:<account_ID>:<object_path>`
     * When `resources.type` equals `AWS::ManagedBlockchain::Node`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in the following format:
     *    + `arn:<partition>:managedblockchain:<region>:<account_ID>:nodes/<node_ID>`
     * When `resources.type` equals `AWS::S3ObjectLambda::AccessPoint`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in the following format:
     *    + `arn:<partition>:s3-object-lambda:<region>:<account_ID>:accesspoint/<access_point_name>`
     * When `resources.type` equals `AWS::EC2::Snapshot`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in the following format:
     *    + `arn:<partition>:ec2:<region>::snapshot/<snapshot_ID>`
     * When `resources.type` equals `AWS::DynamoDB::Stream`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in the following format:
     *    + `arn:<partition>:dynamodb:<region>:<account_ID>:table/<table_name>/stream/<date_time>`
     * When `resources.type` equals `AWS::Glue::Table`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in the following format:
     *    + `arn:<partition>:glue:<region>:<account_ID>:table/<database_name>/<table_name>`
     */
    val field: kotlin.String? = builder.field
    /**
     * An operator that excludes events that match the last few characters of the event record field specified as the value of `Field`.
     */
    val notEndsWith: List<String>? = builder.notEndsWith
    /**
     * An operator that excludes events that match the exact value of the event record field specified as the value of `Field`.
     */
    val notEquals: List<String>? = builder.notEquals
    /**
     * An operator that excludes events that match the first few characters of the event record field specified as the value of `Field`.
     */
    val notStartsWith: List<String>? = builder.notStartsWith
    /**
     * An operator that includes events that match the first few characters of the event record field specified as the value of `Field`.
     */
    val startsWith: List<String>? = builder.startsWith

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudtrail.model.AdvancedFieldSelector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdvancedFieldSelector(")
        append("endsWith=$endsWith,")
        append("equals=$equals,")
        append("field=$field,")
        append("notEndsWith=$notEndsWith,")
        append("notEquals=$notEquals,")
        append("notStartsWith=$notStartsWith,")
        append("startsWith=$startsWith)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endsWith?.hashCode() ?: 0
        result = 31 * result + (equals?.hashCode() ?: 0)
        result = 31 * result + (field?.hashCode() ?: 0)
        result = 31 * result + (notEndsWith?.hashCode() ?: 0)
        result = 31 * result + (notEquals?.hashCode() ?: 0)
        result = 31 * result + (notStartsWith?.hashCode() ?: 0)
        result = 31 * result + (startsWith?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdvancedFieldSelector

        if (endsWith != other.endsWith) return false
        if (equals != other.equals) return false
        if (field != other.field) return false
        if (notEndsWith != other.notEndsWith) return false
        if (notEquals != other.notEquals) return false
        if (notStartsWith != other.notStartsWith) return false
        if (startsWith != other.startsWith) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudtrail.model.AdvancedFieldSelector = Builder(this).apply(block).build()

    class Builder {
        /**
         * An operator that includes events that match the last few characters of the event record field specified as the value of `Field`.
         */
        var endsWith: List<String>? = null
        /**
         * An operator that includes events that match the exact value of the event record field specified as the value of `Field`. This is the only valid operator that you can use with the `readOnly`, `eventCategory`, and `resources.type` fields.
         */
        var equals: List<String>? = null
        /**
         * A field in an event record on which to filter events to be logged. Supported fields include `readOnly`, `eventCategory`, `eventSource` (for management events), `eventName`, `resources.type`, and `resources.ARN`.
         * + **`readOnly`** - Optional. Can be set to `Equals` a value of `true` or `false`. If you do not add this field, CloudTrail logs both both `read` and `write` events. A value of `true` logs only `read` events. A value of `false` logs only `write` events.
         * + **`eventSource`** - For filtering management events only. This can be set only to `NotEquals``kms.amazonaws.com`.
         * + **`eventName`** - Can use any operator. You can use it to ﬁlter in or ﬁlter out any data event logged to CloudTrail, such as `PutBucket` or `GetSnapshotBlock`. You can have multiple values for this ﬁeld, separated by commas.
         * + **`eventCategory`** - This is required. It must be set to `Equals`, and the value must be `Management` or `Data`.
         * + **`resources.type`** - This ﬁeld is required. `resources.type` can only use the `Equals` operator, and the value can be one of the following:
         *    + `AWS::S3::Object`
         *    + `AWS::Lambda::Function`
         *    + `AWS::DynamoDB::Table`
         *    + `AWS::S3Outposts::Object`
         *    + `AWS::ManagedBlockchain::Node`
         *    + `AWS::S3ObjectLambda::AccessPoint`
         *    + `AWS::EC2::Snapshot`
         *    + `AWS::S3::AccessPoint`
         *    + `AWS::DynamoDB::Stream`
         *    + `AWS::Glue::Table`
         *  You can have only one `resources.type` ﬁeld per selector. To log data events on more than one resource type, add another selector.
         * + **`resources.ARN`** - You can use any operator with `resources.ARN`, but if you use `Equals` or `NotEquals`, the value must exactly match the ARN of a valid resource of the type you've speciﬁed in the template as the value of resources.type. For example, if resources.type equals `AWS::S3::Object`, the ARN must be in one of the following formats. To log all data events for all objects in a specific S3 bucket, use the `StartsWith` operator, and include only the bucket ARN as the matching value.The trailing slash is intentional; do not exclude it. Replace the text between less than and greater than symbols (<>) with resource-specific information.
         *    + `arn:<partition>:s3:::<bucket_name>/`
         *    + `arn:<partition>:s3:::<bucket_name>/<object_path>/`
         * When `resources.type` equals `AWS::S3::AccessPoint`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in one of the following formats. To log events on all objects in an S3 access point, we recommend that you use only the access point ARN, don’t include the object path, and use the `StartsWith` or `NotStartsWith` operators.
         *    + `arn:<partition>:s3:<region>:<account_ID>:accesspoint/<access_point_name>`
         *    + `arn:<partition>:s3:<region>:<account_ID>:accesspoint/<access_point_name>/object/<object_path>`
         * When resources.type equals `AWS::Lambda::Function`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in the following format:
         *    + `arn:<partition>:lambda:<region>:<account_ID>:function:<function_name>`
         * When resources.type equals `AWS::DynamoDB::Table`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in the following format:
         *    + `arn:<partition>:dynamodb:<region>:<account_ID>:table/<table_name>`
         * When `resources.type` equals `AWS::S3Outposts::Object`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in the following format:
         *    + `arn:<partition>:s3-outposts:<region>:<account_ID>:<object_path>`
         * When `resources.type` equals `AWS::ManagedBlockchain::Node`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in the following format:
         *    + `arn:<partition>:managedblockchain:<region>:<account_ID>:nodes/<node_ID>`
         * When `resources.type` equals `AWS::S3ObjectLambda::AccessPoint`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in the following format:
         *    + `arn:<partition>:s3-object-lambda:<region>:<account_ID>:accesspoint/<access_point_name>`
         * When `resources.type` equals `AWS::EC2::Snapshot`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in the following format:
         *    + `arn:<partition>:ec2:<region>::snapshot/<snapshot_ID>`
         * When `resources.type` equals `AWS::DynamoDB::Stream`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in the following format:
         *    + `arn:<partition>:dynamodb:<region>:<account_ID>:table/<table_name>/stream/<date_time>`
         * When `resources.type` equals `AWS::Glue::Table`, and the operator is set to `Equals` or `NotEquals`, the ARN must be in the following format:
         *    + `arn:<partition>:glue:<region>:<account_ID>:table/<database_name>/<table_name>`
         */
        var field: kotlin.String? = null
        /**
         * An operator that excludes events that match the last few characters of the event record field specified as the value of `Field`.
         */
        var notEndsWith: List<String>? = null
        /**
         * An operator that excludes events that match the exact value of the event record field specified as the value of `Field`.
         */
        var notEquals: List<String>? = null
        /**
         * An operator that excludes events that match the first few characters of the event record field specified as the value of `Field`.
         */
        var notStartsWith: List<String>? = null
        /**
         * An operator that includes events that match the first few characters of the event record field specified as the value of `Field`.
         */
        var startsWith: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudtrail.model.AdvancedFieldSelector) : this() {
            this.endsWith = x.endsWith
            this.equals = x.equals
            this.field = x.field
            this.notEndsWith = x.notEndsWith
            this.notEquals = x.notEquals
            this.notStartsWith = x.notStartsWith
            this.startsWith = x.startsWith
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudtrail.model.AdvancedFieldSelector = AdvancedFieldSelector(this)
    }
}
